/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.Map;
import org.terracotta.persistence.sanskrit.MutableSanskritObject;
import org.terracotta.persistence.sanskrit.ObjectMapperSupplier;
import org.terracotta.persistence.sanskrit.SanskritException;
import org.terracotta.persistence.sanskrit.SanskritObjectImpl;

public class JsonUtils {
    public static void parse(ObjectMapperSupplier objectMapperSupplier, String version, String json, MutableSanskritObject result) throws SanskritException {
        try {
            JsonNode jsonNode = objectMapperSupplier.getObjectMapper(version).readTree(json);
            JsonUtils.jsonNodeToSanskritObject(objectMapperSupplier, version, result, jsonNode);
        }
        catch (IOException e) {
            throw new SanskritException(e);
        }
    }

    private static void jsonNodeToSanskritObject(ObjectMapperSupplier objectMapperSupplier, String version, MutableSanskritObject sanskritObject, JsonNode jsonNode) throws SanskritException {
        block6: for (Map.Entry field : () -> ((JsonNode)jsonNode).fields()) {
            String key = (String)field.getKey();
            JsonNode value = (JsonNode)field.getValue();
            JsonNodeType nodeType = value.getNodeType();
            switch (nodeType) {
                case NUMBER: {
                    sanskritObject.setLong(key, value.longValue());
                    continue block6;
                }
                case STRING: {
                    sanskritObject.setString(key, value.textValue());
                    continue block6;
                }
                case OBJECT: {
                    sanskritObject.setObject(key, JsonUtils.jsonNodeToSanskritObject(objectMapperSupplier, version, value));
                    continue block6;
                }
                case NULL: {
                    sanskritObject.removeKey(key);
                    continue block6;
                }
            }
            sanskritObject.setExternal(key, value, version);
        }
    }

    private static MutableSanskritObject jsonNodeToSanskritObject(ObjectMapperSupplier objectMapperSupplier, String version, JsonNode jsonNode) throws SanskritException {
        SanskritObjectImpl sanskritObject = new SanskritObjectImpl(objectMapperSupplier);
        JsonUtils.jsonNodeToSanskritObject(objectMapperSupplier, version, sanskritObject, jsonNode);
        return sanskritObject;
    }
}

