/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.terracotta.persistence.sanskrit.ObjectMapperSupplier;
import org.terracotta.persistence.sanskrit.SanskritException;
import org.terracotta.persistence.sanskrit.SanskritObject;
import org.terracotta.persistence.sanskrit.change.SanskritChangeVisitor;

public class JsonSanskritChangeVisitor
implements SanskritChangeVisitor {
    private final ObjectMapperSupplier objectMapperSupplier;
    private final ObjectNode objectNode;

    public JsonSanskritChangeVisitor(ObjectMapperSupplier objectMapperSupplier) {
        this(objectMapperSupplier, objectMapperSupplier.getObjectMapper().createObjectNode());
    }

    public JsonSanskritChangeVisitor(ObjectMapperSupplier objectMapperSupplier, ObjectNode objectNode) {
        this.objectMapperSupplier = objectMapperSupplier;
        this.objectNode = objectNode;
    }

    public String getJson(String version) throws SanskritException {
        try {
            return this.objectMapperSupplier.getObjectMapper(version).writeValueAsString((Object)this.objectNode);
        }
        catch (JsonProcessingException e) {
            throw new SanskritException(e);
        }
    }

    @Override
    public void setString(String key, String value) {
        this.objectNode.put(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.objectNode.put(key, value);
    }

    @Override
    public void setObject(String key, SanskritObject value) {
        ObjectNode childObjectNode = this.objectNode.objectNode();
        value.accept(new JsonSanskritChangeVisitor(this.objectMapperSupplier, childObjectNode));
        this.objectNode.set(key, (JsonNode)childObjectNode);
    }

    @Override
    public void removeKey(String key) {
        NullNode nullNode = this.objectNode.nullNode();
        this.objectNode.set(key, (JsonNode)nullNode);
    }

    @Override
    public <T> void setExternal(String key, T value, String version) {
        this.objectNode.set(key, value instanceof JsonNode ? (JsonNode)value : this.objectMapperSupplier.getObjectMapper(version).valueToTree(value));
    }
}

