/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashUtils.class);
    private static final byte[] PRIVATE_BYTES = HashUtils.toBytes(113, 13, 113, 209, 202, 205, 209, 225, 139, 86, 135, 102, 14, 53, 132, 235, 189, 244, 140, 161, 1, 65, 243, 159, 246, 100, 126, 51, 142, 237, 209, 91, 209, 117, 62, 103, 235, 118, 28, 80, 148, 61, 190, 86, 200, 66, 224, 158, 40, 181, 202, 213, 73, 217, 204, 119, 186, 105, 73, 69, 216, 27, 73, 201);

    private static byte[] toBytes(int ... ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    public static String generateHash(String ... inputs) {
        return HashUtils.generateHash(String.join((CharSequence)"", inputs));
    }

    public static String generateHash(String input) {
        String hash = HashUtils.generateHash(input.getBytes(StandardCharsets.UTF_8));
        LOGGER.trace("generateHash({}): {}", (Object)input, (Object)hash);
        return hash;
    }

    public static String generateHash(byte[] input) {
        return HashUtils.toHexText(Arrays.copyOf(HashUtils.digest(input), 20));
    }

    private static byte[] digest(byte[] input) {
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA-512");
            digester.update(input);
            digester.update(PRIVATE_BYTES);
            return digester.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"Missing hash algorithm: SHA-512");
        }
    }

    private static String toHexText(byte[] input) {
        StringBuilder sb = new StringBuilder(input.length * 2);
        for (byte b : input) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

