/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.persistence.sanskrit.SanskritException;

public class HashChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashChecker.class);
    private final Map<String, String> hashes = new HashMap<String, String>(2);
    private boolean laterHash;
    private String removedFirst;
    private int hashCount;

    public HashChecker(String hash0, String hash1) {
        LOGGER.trace("HashChecker({}, {})", (Object)hash0, (Object)hash1);
        if (hash0 != null) {
            this.hashes.put(hash0, "hash0");
            ++this.hashCount;
        }
        if (hash1 != null) {
            this.hashes.put(hash1, "hash1");
            ++this.hashCount;
        }
    }

    public boolean check(String hash) throws SanskritException {
        if (this.hashes.isEmpty()) {
            if (this.laterHash) {
                throw new SanskritException("Found hashes after the last recorded hash");
            }
            this.laterHash = true;
            LOGGER.trace("check({}): {}", (Object)hash, (Object)false);
            return false;
        }
        String removed = this.hashes.remove(hash);
        LOGGER.trace("check({}): removed: {}", (Object)hash, (Object)removed);
        if (removed != null) {
            if (this.removedFirst == null) {
                this.removedFirst = removed;
            }
        } else if (this.removedFirst != null) {
            throw new SanskritException("Found extra hash between final hashes: " + hash);
        }
        LOGGER.trace("check({}): {}", (Object)hash, (Object)true);
        return true;
    }

    public String done() throws SanskritException {
        if (!this.hashes.isEmpty()) {
            throw new SanskritException("Hash existed but no matching record: " + this.hashes);
        }
        if (this.hashCount == 2) {
            LOGGER.trace("done(): {}", (Object)this.removedFirst);
            return this.removedFirst;
        }
        LOGGER.trace("done(): <none>");
        return null;
    }

    public String nextHashFile() {
        if (this.hashCount == 2) {
            LOGGER.trace("nextHashFile(): {}", (Object)this.removedFirst);
            return this.removedFirst;
        }
        if (this.hashCount == 1) {
            String inverted = this.invert(this.removedFirst);
            LOGGER.trace("nextHashFile(): inverted: {}", (Object)inverted);
            return inverted;
        }
        LOGGER.trace("nextHashFile(): hash0");
        return "hash0";
    }

    private String invert(String removedFirst) {
        if ("hash0".equals(removedFirst)) {
            return "hash1";
        }
        return "hash0";
    }
}

