/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupingSpliterator
implements Spliterator<Deque<String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupingSpliterator.class);
    private final Spliterator<String> lines;

    public GroupingSpliterator(Stream<String> lines) {
        this(lines.spliterator());
    }

    public GroupingSpliterator(Spliterator<String> lines) {
        this.lines = lines;
    }

    @Override
    public boolean tryAdvance(Consumer<? super Deque<String>> action) {
        ArrayDeque batch = new ArrayDeque();
        boolean stopBatch = false;
        AtomicBoolean batchFull = new AtomicBoolean();
        while (!stopBatch) {
            boolean more = this.lines.tryAdvance((? super T line) -> {
                if (line.equals("")) {
                    batchFull.set(true);
                    LOGGER.trace("end of batch");
                } else {
                    batch.add(line);
                    LOGGER.trace("new line: {}", (Object)line.replace("\r", "\\r").replace("\n", "\\n"));
                }
            });
            if (more && !batchFull.get()) continue;
            stopBatch = true;
        }
        if (!batchFull.get()) {
            LOGGER.trace("no more lines");
            return false;
        }
        LOGGER.trace("batch: {}", batch);
        action.accept(batch);
        return true;
    }

    @Override
    public Spliterator<Deque<String>> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 1296;
    }
}

