/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;

public class TerracottaJsonModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public TerracottaJsonModule() {
        super(TerracottaJsonModule.class.getSimpleName(), new Version(1, 0, 0, null, null, null));
        this.addSerializer(Path.class, (JsonSerializer)new StdSerializer<Path>(Path.class){
            private static final long serialVersionUID = 1L;

            public void serialize(Path value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeStartArray();
                for (Path segment : value) {
                    gen.writeString(segment.toString());
                }
                gen.writeEndArray();
            }
        });
        this.addDeserializer(Path.class, (JsonDeserializer)new StdDeserializer<Path>(Path.class){
            private static final long serialVersionUID = 1L;

            public Path deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                ArrayDeque<String> segments;
                block6: {
                    segments = new ArrayDeque<String>();
                    try {
                        if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                            segments.add(p.getText());
                            break block6;
                        }
                        while (true) {
                            String value;
                            if ((value = p.nextTextValue()) != null) {
                                segments.add(value);
                                continue;
                            }
                            if (p.getCurrentToken() != JsonToken.END_ARRAY) {
                                value = this._parseString(p, ctxt);
                                segments.add(value);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        throw JsonMappingException.wrapWithPath((Throwable)e, segments, (int)segments.size());
                    }
                }
                String first = (String)segments.removeFirst();
                String[] others = segments.toArray(new String[0]);
                return Paths.get(first, others);
            }
        });
    }
}

