/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net;

import com.tc.util.runtime.Os;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NIOWorkarounds {
    private NIOWorkarounds() {
    }

    public static boolean windowsWritevWorkaround(IOException ioe) {
        String err = ioe.getMessage();
        return null != err && err.equals("A non-blocking socket operation could not be completed immediately") && Os.isWindows();
    }

    public static boolean linuxSelectWorkaround(IOException ioe) {
        String msg;
        return Os.isLinux() && "Interrupted system call".equals(msg = ioe.getMessage());
    }

    public static boolean solarisOnX86SelectWorkaround(IOException ioe) {
        String msg;
        return Os.isSolaris() && Os.isArchx86() && (msg = ioe.getMessage()) != null && msg.contains("Bad file number");
    }

    public static void solaris10Workaround() {
        boolean workaround = NIOWorkarounds.solaris10Workaround(System.getProperties());
        if (workaround) {
            String prev = System.getProperty("java.nio.channels.spi.SelectorProvider");
            System.setProperty("java.nio.channels.spi.SelectorProvider", "sun.nio.ch.PollSelectorProvider");
            String msg = "\nWARNING: Terracotta is forcing the use of poll based NIO selector to workaround Sun bug 6322825\n";
            if (prev != null) {
                msg = msg + "This overrides the previous value of " + prev + "\n";
            }
            System.err.println(msg);
        }
    }

    static boolean solaris10Workaround(Properties props) {
        String vendor = props.getProperty("java.vendor", "");
        String osName = props.getProperty("os.name", "");
        String osVersion = props.getProperty("os.version", "");
        String javaVersion = props.getProperty("java.version", "");
        if (vendor.toLowerCase().startsWith("sun") && "SunOS".equals(osName) && "5.10".equals(osVersion) && javaVersion.matches("^1\\.[12345]\\..*")) {
            String minorRev;
            int ver;
            Pattern p = Pattern.compile("^1\\.5\\.0_(\\d\\d)$");
            Matcher m = p.matcher(javaVersion);
            return !m.matches() || (ver = Integer.parseInt(minorRev = m.group(1))) < 8;
        }
        return false;
    }

    public static boolean selectorOpenRace(NullPointerException npe) {
        StackTraceElement source = npe.getStackTrace()[0];
        return source.getClassName().equals("sun.nio.ch.Util") && source.getMethodName().equals("atBugLevel");
    }

    public static void main(String[] args) {
        NIOWorkarounds.solaris10Workaround();
    }

    public static boolean connectWorkaround(ClosedSelectorException cse) {
        StackTraceElement[] stackTrace = cse.getStackTrace();
        if (stackTrace.length < 3) {
            return false;
        }
        StackTraceElement f1 = stackTrace[0];
        StackTraceElement f2 = stackTrace[1];
        StackTraceElement f3 = stackTrace[2];
        return f1.getClassName().equals("sun.nio.ch.SelectorImpl") && f1.getMethodName().equals("lockAndDoSelect") && f2.getClassName().equals("sun.nio.ch.SelectorImpl") && f2.getMethodName().equals("selectNow") && f3.getClassName().equals("sun.nio.ch.Util") && f3.getMethodName().equals("releaseTemporarySelector");
    }
}

