/*
 * Decompiled with CFR 0.152.
 */
package com.tc.timapi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private final int major;
    private final int minor;
    private final int incremental;
    private final String qualifier;
    private final boolean isSnapshot;
    private final String versionString;

    Version(Properties props) {
        String ver = props.getProperty("version");
        if (ver == null) {
            throw new AssertionError((Object)"missing version property");
        }
        ver = ver.trim();
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)-?(.*)?$");
        Matcher m = pattern.matcher(ver);
        if (!m.matches()) {
            throw new AssertionError((Object)("unexpected version string: " + ver));
        }
        this.versionString = ver;
        this.major = Integer.parseInt(m.group(1));
        this.minor = Integer.parseInt(m.group(2));
        this.incremental = Integer.parseInt(m.group(3));
        this.qualifier = m.group(4);
        this.isSnapshot = "SNAPSHOT".equals(this.qualifier);
    }

    public static Version getVersion() {
        return DefaultInstanceHolder.INSTANCE;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getIncremental() {
        return this.incremental;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getFullVersionString() {
        return this.versionString;
    }

    private static class DefaultInstanceHolder {
        static final Version INSTANCE = DefaultInstanceHolder.loadDefault();

        private DefaultInstanceHolder() {
        }

        private static Version loadDefault() {
            InputStream in = Version.class.getResourceAsStream("version.properties");
            if (in == null) {
                throw new AssertionError((Object)"Missing version.properties resource");
            }
            try {
                Properties props = new Properties();
                props.load(in);
                Version version = new Version(props);
                return version;
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

