/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode.rwsync;

import com.tc.asm.ClassVisitor;
import com.tc.asm.Label;
import com.tc.asm.MethodAdapter;
import com.tc.asm.MethodVisitor;
import com.tc.asm.Type;
import com.tc.object.bytecode.ByteCodeUtil;
import com.tc.object.bytecode.rwsync.LockingMethodStrategy;
import java.lang.reflect.Modifier;

public class SimpleLockMethodStrategy
extends LockingMethodStrategy {
    public SimpleLockMethodStrategy(LockingMethodStrategy.LockType lockType) {
        super(lockType);
    }

    public MethodVisitor visitMethod(ClassVisitor cv, String ownerType, String outerType, String outerDesc, int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = cv.visitMethod(access, name, desc, signature, exceptions);
        mv = new LockWrapAdapter(mv, ownerType, outerType, outerDesc, access, name, desc);
        mv.visitCode();
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cv.visitMethod(SimpleLockMethodStrategy.getWrappedAttributes(access), SimpleLockMethodStrategy.getWrappedName(name), desc, signature, exceptions);
    }

    private class LockWrapAdapter
    extends MethodAdapter {
        private final String ownerType;
        private final String outerType;
        private final String outerDesc;
        private final int access;
        private final String name;
        private final String desc;

        public LockWrapAdapter(MethodVisitor mv, String ownerType, String outerType, String outerDesc, int access, String name, String desc) {
            super(mv);
            this.ownerType = ownerType;
            this.outerType = outerType;
            this.outerDesc = outerDesc;
            this.access = access;
            this.name = name;
            this.desc = desc;
        }

        public void visitCode() {
            Type type = Type.getReturnType(this.desc);
            boolean isVoid = type.getSort() == 0;
            int opStore = type.getOpcode(54);
            int opLoad = type.getOpcode(21);
            int opReturn = type.getOpcode(172);
            int lviCaughtException = ByteCodeUtil.getFirstLocalVariableOffset(this.access, this.desc);
            int lviReturn = lviCaughtException + 1;
            super.visitCode();
            Label lblTryStart = new Label();
            Label lblTryEnd = new Label();
            Label lblTryHandler = new Label();
            this.visitTryCatchBlock(lblTryStart, lblTryEnd, lblTryHandler, null);
            this.visitVarInsn(25, 0);
            if (this.outerType != null) {
                this.visitFieldInsn(180, this.ownerType, "this$0", this.outerDesc);
                this.visitFieldInsn(180, this.outerType, SimpleLockMethodStrategy.this.lockField, SimpleLockMethodStrategy.this.lockTypeDesc);
            } else {
                this.visitFieldInsn(180, this.ownerType, SimpleLockMethodStrategy.this.lockField, SimpleLockMethodStrategy.this.lockTypeDesc);
            }
            this.visitMethodInsn(182, SimpleLockMethodStrategy.this.lockTypeName, "lock", "()V");
            this.visitLabel(lblTryStart);
            this.callRenamedMethod();
            if (!isVoid) {
                this.visitVarInsn(opStore, lviReturn);
            }
            this.visitLabel(lblTryEnd);
            this.visitVarInsn(25, 0);
            if (this.outerType != null) {
                this.visitFieldInsn(180, this.ownerType, "this$0", this.outerDesc);
                this.visitFieldInsn(180, this.outerType, SimpleLockMethodStrategy.this.lockField, SimpleLockMethodStrategy.this.lockTypeDesc);
            } else {
                this.visitFieldInsn(180, this.ownerType, SimpleLockMethodStrategy.this.lockField, SimpleLockMethodStrategy.this.lockTypeDesc);
            }
            this.visitMethodInsn(182, SimpleLockMethodStrategy.this.lockTypeName, "unlock", "()V");
            if (!isVoid) {
                this.visitVarInsn(opLoad, lviReturn);
            }
            this.visitInsn(opReturn);
            this.visitLabel(lblTryHandler);
            this.visitVarInsn(58, lviCaughtException);
            this.visitVarInsn(25, 0);
            if (this.outerType != null) {
                this.visitFieldInsn(180, this.ownerType, "this$0", this.outerDesc);
                this.visitFieldInsn(180, this.outerType, SimpleLockMethodStrategy.this.lockField, SimpleLockMethodStrategy.this.lockTypeDesc);
            } else {
                this.visitFieldInsn(180, this.ownerType, SimpleLockMethodStrategy.this.lockField, SimpleLockMethodStrategy.this.lockTypeDesc);
            }
            this.visitMethodInsn(182, SimpleLockMethodStrategy.this.lockTypeName, "unlock", "()V");
            this.visitVarInsn(25, lviCaughtException);
            this.visitInsn(191);
        }

        private void callRenamedMethod() {
            ByteCodeUtil.prepareStackForMethodCall(this.access, this.desc, this.mv);
            int invokeOp = Modifier.isStatic(this.access) ? 184 : 183;
            this.visitMethodInsn(invokeOp, this.ownerType, LockingMethodStrategy.getWrappedName(this.name), this.desc);
        }
    }
}

