/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode.rwsync;

import com.tc.asm.ClassAdapter;
import com.tc.asm.ClassVisitor;
import com.tc.asm.MethodVisitor;
import com.tc.asm.Opcodes;
import com.tc.logging.TCLogger;
import com.tc.object.bytecode.ManagerUtil;
import com.tc.object.bytecode.rwsync.InitMethodStrategy;
import com.tc.object.bytecode.rwsync.LockingMethodStrategy;
import com.tc.object.bytecode.rwsync.MethodId;
import com.tc.object.bytecode.rwsync.MethodStrategy;
import com.tc.object.bytecode.rwsync.NoLockMethodStrategy;
import com.tc.object.bytecode.rwsync.SimpleLockMethodStrategy;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LockingClassAdapter
extends ClassAdapter
implements Opcodes {
    protected static final MethodStrategy INIT_STRATEGY = new InitMethodStrategy();
    protected static final MethodStrategy NOLOCK_STRATEGY = new NoLockMethodStrategy();
    protected static final MethodStrategy READLOCK_STRATEGY = new SimpleLockMethodStrategy(LockingMethodStrategy.LockType.READ);
    protected static final MethodStrategy WRITELOCK_STRATEGY = new SimpleLockMethodStrategy(LockingMethodStrategy.LockType.WRITE);

    protected abstract String getOwnerType();

    protected abstract String getOwnerTypeDots();

    protected abstract String getOuterType();

    protected abstract String getOuterDesc();

    protected abstract Map<MethodId, MethodStrategy> getLockingStrategy();

    public LockingClassAdapter(ClassVisitor cv) {
        super(cv);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodStrategy strategy = this.getLockingStrategy().get(new MethodId(name, desc));
        if (strategy == null) {
            String msg = "Encountered unexpected method \"" + name + "()\" " + desc + " while instrumenting class " + this.getOwnerTypeDots() + ": resulting code may not be threadsafe. " + "Check that the version of the library that contains this class matches the version expected by the TIM.";
            TCLogger log = ManagerUtil.getLogger("com.tc.object.bytecode.rwsync.LockingClassAdapter");
            log.warn(msg);
            strategy = NOLOCK_STRATEGY;
        }
        MethodVisitor mv = strategy.visitMethod(this.cv, this.getOwnerType(), this.getOuterType(), this.getOuterDesc(), access, name, desc, signature, exceptions);
        return mv;
    }

    protected void addLockFields() {
        this.cv.visitField(20, "__tc_readWriteLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", null, null);
        this.cv.visitField(20, "__tc_readLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock$ReadLock;", null, null);
        this.cv.visitField(20, "__tc_writeLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;", null, null);
    }
}

