/*
 * Decompiled with CFR 0.152.
 */
package com.tc.backport175.bytecode;

import com.tc.asm.AnnotationVisitor;
import com.tc.asm.ClassReader;
import com.tc.asm.FieldVisitor;
import com.tc.asm.MethodVisitor;
import com.tc.asm.Type;
import com.tc.asm.commons.EmptyVisitor;
import com.tc.backport175.Annotation;
import com.tc.backport175.bytecode.AnnotationDefaults;
import com.tc.backport175.bytecode.AnnotationElement;
import com.tc.backport175.bytecode.DefaultBytecodeProvider;
import com.tc.backport175.bytecode.SignatureHelper;
import com.tc.backport175.bytecode.spi.BytecodeProvider;
import com.tc.backport175.proxy.ProxyFactory;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class AnnotationReader {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final AnnotationElement.Annotation[] EMPTY_ANNOTATION_ELEMENT_ARRAY = new AnnotationElement.Annotation[0];
    private static final String INIT_METHOD_NAME = "<init>";
    private static final Map CLASS_SPECIFIC_BYTECODE_PROVIDER = new WeakHashMap();
    private static volatile BytecodeProvider BYTECODE_PROVIDER = new DefaultBytecodeProvider();
    private static final Map READERS = new WeakHashMap();
    private final ClassKey m_classKey;
    private final Map m_classAnnotationElements = new HashMap();
    private final Map m_constructorAnnotationElements = new HashMap();
    private final Map m_methodAnnotationElements = new HashMap();
    private final Map m_fieldAnnotationElements = new HashMap();
    private final Map m_classAnnotationCache = new HashMap();
    private final Map m_constructorAnnotationCache = new HashMap();
    private final Map m_methodAnnotationCache = new HashMap();
    private final Map m_fieldAnnotationCache = new HashMap();

    public static void setDefaultBytecodeProvider(BytecodeProvider bytecodeProvider) {
        BYTECODE_PROVIDER = bytecodeProvider;
    }

    public static BytecodeProvider getDefaultBytecodeProvider() {
        return BYTECODE_PROVIDER;
    }

    public static void setBytecodeProviderFor(Class klass, BytecodeProvider bytecodeProvider) {
        AnnotationReader.setBytecodeProviderFor(klass.getName(), klass.getClassLoader(), bytecodeProvider);
    }

    public static void setBytecodeProviderFor(String className, ClassLoader loader, BytecodeProvider bytecodeProvider) {
        CLASS_SPECIFIC_BYTECODE_PROVIDER.put(new ClassKey(className, loader), bytecodeProvider);
    }

    public static BytecodeProvider getBytecodeProviderFor(Class klass) {
        return AnnotationReader.getBytecodeProviderFor(klass.getName(), klass.getClassLoader());
    }

    public static BytecodeProvider getBytecodeProviderFor(String className, ClassLoader loader) {
        BytecodeProvider bytecodeProvider = (BytecodeProvider)CLASS_SPECIFIC_BYTECODE_PROVIDER.get(new ClassKey(className, loader));
        if (bytecodeProvider == null) {
            return BYTECODE_PROVIDER;
        }
        return bytecodeProvider;
    }

    public static byte[] getBytecodeFor(String className, ClassLoader loader) throws ClassNotFoundException, IOException {
        return AnnotationReader.getBytecodeProviderFor(className, loader).getBytecode(className, loader);
    }

    public static AnnotationReader getReaderFor(Class klass) {
        return AnnotationReader.getReaderFor(new ClassKey(klass.getName(), klass.getClassLoader()));
    }

    public static AnnotationReader getReaderFor(String className, ClassLoader loader) {
        return AnnotationReader.getReaderFor(new ClassKey(className, loader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnnotationReader getReaderFor(ClassKey classKey) {
        Reference ref;
        Map map = READERS;
        synchronized (map) {
            ref = (Reference)READERS.get(classKey);
        }
        AnnotationReader reader = ref == null ? null : ref.get();
        if (reader == null) {
            reader = new AnnotationReader(classKey);
            Map map2 = READERS;
            synchronized (map2) {
                READERS.put(classKey, new WeakReference<AnnotationReader>(reader));
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(Class klass) {
        AnnotationReader reader;
        AnnotationReader annotationReader = reader = AnnotationReader.getReaderFor(klass);
        synchronized (annotationReader) {
            reader.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(String className, ClassLoader loader) {
        AnnotationReader reader;
        AnnotationReader annotationReader = reader = AnnotationReader.getReaderFor(className, loader);
        synchronized (annotationReader) {
            reader.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAll() {
        Object[] readers;
        Map map = READERS;
        synchronized (map) {
            readers = READERS.values().toArray();
        }
        for (int i = 0; i < readers.length; ++i) {
            AnnotationReader reader = (AnnotationReader)((Reference)readers[i]).get();
            if (reader == null) continue;
            AnnotationReader annotationReader = reader;
            synchronized (annotationReader) {
                reader.refresh();
                continue;
            }
        }
    }

    public static String toJavaName(String desc) {
        return desc.substring(1, desc.length() - 1).replace('/', '.');
    }

    public boolean isAnnotationPresent(String annotationName) {
        return this.m_classAnnotationElements.containsKey(annotationName);
    }

    public Annotation getAnnotation(String annotationName) {
        Object cachedAnnotation = this.m_classAnnotationCache.get(annotationName);
        if (cachedAnnotation != null) {
            return (Annotation)cachedAnnotation;
        }
        AnnotationElement.Annotation annotationInfo = (AnnotationElement.Annotation)this.m_classAnnotationElements.get(annotationName);
        if (annotationInfo != null) {
            Annotation annotation = ProxyFactory.newAnnotationProxy(annotationInfo, this.m_classKey.getClassLoader());
            this.m_classAnnotationCache.put(annotationName, annotation);
            return annotation;
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        Set annotationNames = this.m_classAnnotationElements.keySet();
        if (annotationNames.isEmpty()) {
            return EMPTY_ANNOTATION_ARRAY;
        }
        Annotation[] annotations = new Annotation[annotationNames.size()];
        int i = 0;
        for (String annotationName : annotationNames) {
            annotations[i++] = this.getAnnotation(annotationName);
        }
        return annotations;
    }

    public boolean isAnnotationPresent(String annotationName, Constructor constructor) {
        MemberKey key = MemberKey.newConstructorKey(constructor);
        Object map = this.m_constructorAnnotationElements.get(key);
        return map != null && ((Map)map).containsKey(annotationName);
    }

    public Annotation getAnnotation(String annotationName, Constructor constructor) {
        return this.getConstructorAnnotation(annotationName, MemberKey.newConstructorKey(constructor), constructor.getDeclaringClass().getClassLoader());
    }

    public Annotation getConstructorAnnotation(String annotationName, String constructorDesc, ClassLoader loader) {
        return this.getConstructorAnnotation(annotationName, MemberKey.newConstructorKey(constructorDesc), loader);
    }

    private Annotation getConstructorAnnotation(String annotationName, MemberKey constructorKey, ClassLoader loader) {
        Map annotationMap = this.getConstructorAnnotationCacheFor(constructorKey);
        Object cachedAnnotation = annotationMap.get(annotationName);
        if (cachedAnnotation != null) {
            return (Annotation)cachedAnnotation;
        }
        Map annotations = (Map)this.m_constructorAnnotationElements.get(constructorKey);
        if (annotations == null) {
            return null;
        }
        Object annotationElement = annotations.get(annotationName);
        if (annotationElement != null) {
            Annotation annotation = ProxyFactory.newAnnotationProxy((AnnotationElement.Annotation)annotationElement, loader);
            annotationMap.put(annotationName, annotation);
            return annotation;
        }
        return null;
    }

    public Annotation[] getAnnotations(Constructor constructor) {
        MemberKey key = MemberKey.newConstructorKey(constructor);
        Object map = this.m_constructorAnnotationElements.get(key);
        if (map != null) {
            Set annotationNames = ((Map)map).keySet();
            if (annotationNames.isEmpty()) {
                return EMPTY_ANNOTATION_ARRAY;
            }
            Annotation[] annotations = new Annotation[annotationNames.size()];
            int i = 0;
            for (String annotationName : annotationNames) {
                annotations[i++] = this.getAnnotation(annotationName, constructor);
            }
            return annotations;
        }
        return EMPTY_ANNOTATION_ARRAY;
    }

    public boolean isAnnotationPresent(String annotationName, Method method) {
        MemberKey key = MemberKey.newMethodKey(method);
        Object map = this.m_methodAnnotationElements.get(key);
        return map != null && ((Map)this.m_methodAnnotationElements.get(key)).containsKey(annotationName);
    }

    public Annotation getAnnotation(String annotationName, Method method) {
        return this.getMethodAnnotation(annotationName, MemberKey.newMethodKey(method), method.getDeclaringClass().getClassLoader());
    }

    public Annotation getMethodAnnotation(String annotationName, String methodName, String methodDesc, ClassLoader loader) {
        return this.getMethodAnnotation(annotationName, MemberKey.newMethodKey(methodName, methodDesc), loader);
    }

    private Annotation getMethodAnnotation(String annotationName, MemberKey methodKey, ClassLoader loader) {
        Map annotationMap = this.getMethodAnnotationCacheFor(methodKey);
        Object cachedAnnotation = annotationMap.get(annotationName);
        if (cachedAnnotation != null) {
            return (Annotation)cachedAnnotation;
        }
        Map annotations = (Map)this.m_methodAnnotationElements.get(methodKey);
        if (annotations == null) {
            return null;
        }
        Object annotationElement = annotations.get(annotationName);
        if (annotationElement != null) {
            Annotation annotation = ProxyFactory.newAnnotationProxy((AnnotationElement.Annotation)annotationElement, loader);
            annotationMap.put(annotationName, annotation);
            return annotation;
        }
        return null;
    }

    public Annotation[] getAnnotations(Method method) {
        MemberKey key = MemberKey.newMethodKey(method);
        Object map = this.m_methodAnnotationElements.get(key);
        if (map != null) {
            Set annotationNames = ((Map)map).keySet();
            if (annotationNames.isEmpty()) {
                return EMPTY_ANNOTATION_ARRAY;
            }
            Annotation[] annotations = new Annotation[annotationNames.size()];
            int i = 0;
            for (String annotationName : annotationNames) {
                annotations[i++] = this.getAnnotation(annotationName, method);
            }
            return annotations;
        }
        return EMPTY_ANNOTATION_ARRAY;
    }

    public boolean isAnnotationPresent(String annotationName, Field field) {
        MemberKey key = MemberKey.newFieldKey(field);
        Object map = this.m_fieldAnnotationElements.get(key);
        return map != null && ((Map)map).containsKey(annotationName);
    }

    public Annotation getAnnotation(String annotationName, Field field) {
        return this.getFieldAnnotation(annotationName, MemberKey.newFieldKey(field), field.getDeclaringClass().getClassLoader());
    }

    public Annotation getFieldAnnotation(String annotationName, String fieldName, String fieldDesc, ClassLoader loader) {
        return this.getFieldAnnotation(annotationName, MemberKey.newFieldKey(fieldName, fieldDesc), loader);
    }

    private Annotation getFieldAnnotation(String annotationName, MemberKey fieldKey, ClassLoader loader) {
        Map annotationMap = this.getFieldAnnotationCacheFor(fieldKey);
        Object cachedAnnotation = annotationMap.get(annotationName);
        if (cachedAnnotation != null) {
            return (Annotation)cachedAnnotation;
        }
        Map annotations = (Map)this.m_fieldAnnotationElements.get(fieldKey);
        if (annotations == null) {
            return null;
        }
        Object annotationElement = annotations.get(annotationName);
        if (annotationElement != null) {
            Annotation annotation = ProxyFactory.newAnnotationProxy((AnnotationElement.Annotation)annotationElement, loader);
            annotationMap.put(annotationName, annotation);
            return annotation;
        }
        return null;
    }

    public Annotation[] getAnnotations(Field field) {
        MemberKey key = MemberKey.newFieldKey(field);
        Object map = this.m_fieldAnnotationElements.get(key);
        if (map != null) {
            Set annotationNames = ((Map)map).keySet();
            if (annotationNames.isEmpty()) {
                return EMPTY_ANNOTATION_ARRAY;
            }
            Annotation[] annotations = new Annotation[annotationNames.size()];
            int i = 0;
            for (String annotationName : annotationNames) {
                annotations[i++] = this.getAnnotation(annotationName, field);
            }
            return annotations;
        }
        return EMPTY_ANNOTATION_ARRAY;
    }

    public AnnotationElement.Annotation getAnnotationElement(String annotationName) {
        return (AnnotationElement.Annotation)this.m_classAnnotationElements.get(annotationName);
    }

    public AnnotationElement.Annotation[] getAnnotationElements() {
        Collection annotations = this.m_classAnnotationElements.values();
        if (annotations.isEmpty()) {
            return EMPTY_ANNOTATION_ELEMENT_ARRAY;
        }
        return this.createAnnotationElementArray(annotations);
    }

    public boolean isConstructorAnnotationPresent(String annotationName, String desc) {
        MemberKey key = MemberKey.newConstructorKey(desc);
        Object map = this.m_constructorAnnotationElements.get(key);
        return map != null && ((Map)map).containsKey(annotationName);
    }

    public AnnotationElement.Annotation getConstructorAnnotationElement(String annotationName, String desc) {
        MemberKey key = MemberKey.newConstructorKey(desc);
        Map annotations = (Map)this.m_constructorAnnotationElements.get(key);
        if (annotations == null) {
            return null;
        }
        return (AnnotationElement.Annotation)annotations.get(annotationName);
    }

    public AnnotationElement.Annotation[] getConstructorAnnotationElements(String desc) {
        MemberKey key = MemberKey.newConstructorKey(desc);
        Object map = this.m_constructorAnnotationElements.get(key);
        if (map != null) {
            Collection annotations = ((Map)map).values();
            if (annotations.isEmpty()) {
                return EMPTY_ANNOTATION_ELEMENT_ARRAY;
            }
            return this.createAnnotationElementArray(annotations);
        }
        return EMPTY_ANNOTATION_ELEMENT_ARRAY;
    }

    public boolean isMethodAnnotationPresent(String annotationName, String name, String desc) {
        MemberKey key = MemberKey.newMethodKey(name, desc);
        Object map = this.m_methodAnnotationElements.get(key);
        return map != null && ((Map)map).containsKey(annotationName);
    }

    public AnnotationElement.Annotation getMethodAnnotationElement(String annotationName, String name, String desc) {
        MemberKey key = MemberKey.newMethodKey(name, desc);
        Map annotations = (Map)this.m_methodAnnotationElements.get(key);
        if (annotations == null) {
            return null;
        }
        return (AnnotationElement.Annotation)annotations.get(annotationName);
    }

    public AnnotationElement.Annotation[] getMethodAnnotationElements(String name, String desc) {
        MemberKey key = MemberKey.newMethodKey(name, desc);
        Object map = this.m_methodAnnotationElements.get(key);
        if (map != null) {
            Collection annotations = ((Map)this.m_methodAnnotationElements.get(key)).values();
            if (annotations.isEmpty()) {
                return EMPTY_ANNOTATION_ELEMENT_ARRAY;
            }
            return this.createAnnotationElementArray(annotations);
        }
        return EMPTY_ANNOTATION_ELEMENT_ARRAY;
    }

    public boolean isFieldAnnotationPresent(String annotationName, String name, String desc) {
        MemberKey key = MemberKey.newFieldKey(name, desc);
        Object map = this.m_fieldAnnotationElements.get(key);
        return map != null && ((Map)map).containsKey(annotationName);
    }

    public AnnotationElement.Annotation getFieldAnnotationElement(String annotationName, String name, String desc) {
        MemberKey key = MemberKey.newFieldKey(name, desc);
        Map annotations = (Map)this.m_fieldAnnotationElements.get(key);
        if (annotations == null) {
            return null;
        }
        return (AnnotationElement.Annotation)annotations.get(annotationName);
    }

    public AnnotationElement.Annotation[] getFieldAnnotationElements(String name, String desc) {
        MemberKey key = MemberKey.newFieldKey(name, desc);
        Object map = this.m_fieldAnnotationElements.get(key);
        if (map != null) {
            Collection annotations = ((Map)this.m_fieldAnnotationElements.get(key)).values();
            if (annotations.isEmpty()) {
                return EMPTY_ANNOTATION_ELEMENT_ARRAY;
            }
            return this.createAnnotationElementArray(annotations);
        }
        return EMPTY_ANNOTATION_ELEMENT_ARRAY;
    }

    private AnnotationElement.Annotation[] createAnnotationElementArray(Collection annotations) {
        int i = 0;
        AnnotationElement.Annotation[] elementArray = new AnnotationElement.Annotation[annotations.size()];
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            elementArray[i++] = (AnnotationElement.Annotation)it.next();
        }
        return elementArray;
    }

    private Map getConstructorAnnotationCacheFor(MemberKey constructor) {
        HashMap annotationMap = (HashMap)this.m_constructorAnnotationCache.get(constructor);
        if (annotationMap == null) {
            annotationMap = new HashMap();
            this.m_constructorAnnotationCache.put(constructor, annotationMap);
        }
        return annotationMap;
    }

    private Map getMethodAnnotationCacheFor(MemberKey method) {
        HashMap annotationMap = (HashMap)this.m_methodAnnotationCache.get(method);
        if (annotationMap == null) {
            annotationMap = new HashMap();
            this.m_methodAnnotationCache.put(method, annotationMap);
        }
        return annotationMap;
    }

    private Map getFieldAnnotationCacheFor(MemberKey field) {
        HashMap annotationMap = (HashMap)this.m_fieldAnnotationCache.get(field);
        if (annotationMap == null) {
            annotationMap = new HashMap();
            this.m_fieldAnnotationCache.put(field, annotationMap);
        }
        return annotationMap;
    }

    private void refresh() {
        this.m_classAnnotationElements.clear();
        this.m_constructorAnnotationElements.clear();
        this.m_methodAnnotationElements.clear();
        this.m_fieldAnnotationElements.clear();
        this.m_classAnnotationCache.clear();
        this.m_constructorAnnotationCache.clear();
        this.m_methodAnnotationCache.clear();
        this.m_fieldAnnotationCache.clear();
        AnnotationDefaults.refresh(this.m_classKey);
        this.parse(this.m_classKey);
    }

    private void parse(ClassKey classKey) {
        byte[] bytes;
        String className = classKey.getName();
        ClassLoader loader = classKey.getClassLoader();
        try {
            bytes = AnnotationReader.getBytecodeFor(className, loader);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        catch (Exception e) {
            System.err.println("[WARN] " + e.getMessage());
            return;
        }
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept(new AnnotationRetrievingVisitor(), 7);
    }

    private AnnotationReader(ClassKey classKey) {
        if (classKey == null) {
            throw new IllegalArgumentException("class info can not be null");
        }
        this.m_classKey = classKey;
        this.parse(classKey);
    }

    public AnnotationVisitor createAnnotationVisitor(AnnotationElement.Annotation annotation) {
        return new AnnotationBuilderVisitor(annotation, this.m_classKey.getClassLoader(), annotation.getInterfaceName());
    }

    private class TraceAnnotationVisitor
    implements AnnotationVisitor {
        private TraceAnnotationVisitor() {
        }

        public void visit(String name, Object value) {
            System.out.println("    NAMED-VALUE: " + name + "->" + value);
        }

        public void visitEnum(String name, String desc, String value) {
            System.out.println("    ENUM: " + name);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            System.out.println("    ANNOTATION: " + name);
            return new TraceAnnotationVisitor();
        }

        public AnnotationVisitor visitArray(String name) {
            System.out.println("    ARRAY: " + name);
            return new TraceAnnotationVisitor();
        }

        public void visitEnd() {
        }
    }

    public static class MemberKey {
        private final String m_name;
        private final String m_desc;

        public static MemberKey newConstructorKey(Constructor method) {
            return new MemberKey(AnnotationReader.INIT_METHOD_NAME, SignatureHelper.getConstructorSignature(method));
        }

        public static MemberKey newConstructorKey(String desc) {
            return new MemberKey(AnnotationReader.INIT_METHOD_NAME, desc);
        }

        public static MemberKey newMethodKey(Method method) {
            return new MemberKey(method.getName(), SignatureHelper.getMethodSignature(method));
        }

        public static MemberKey newMethodKey(String name, String desc) {
            return new MemberKey(name, desc);
        }

        public static MemberKey newFieldKey(Field field) {
            return new MemberKey(field.getName(), SignatureHelper.getFieldSignature(field));
        }

        public static MemberKey newFieldKey(String name, String desc) {
            return new MemberKey(name, desc);
        }

        public MemberKey(String name, String desc) {
            this.m_name = name;
            this.m_desc = desc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MemberKey)) {
                return false;
            }
            MemberKey memberKey = (MemberKey)o;
            if (this.m_desc != null ? !this.m_desc.equals(memberKey.m_desc) : memberKey.m_desc != null) {
                return false;
            }
            return !(this.m_name != null ? !this.m_name.equals(memberKey.m_name) : memberKey.m_name != null);
        }

        public int hashCode() {
            int result = this.m_name != null ? this.m_name.hashCode() : 0;
            result = 29 * result + (this.m_desc != null ? this.m_desc.hashCode() : 0);
            return result;
        }
    }

    public static class ClassKey {
        private final String m_name;
        private final WeakReference m_loaderRef;

        public ClassKey(String name, ClassLoader loader) {
            this.m_name = name.replace('.', '/');
            this.m_loaderRef = new WeakReference<ClassLoader>(loader);
        }

        public String getName() {
            return this.m_name;
        }

        public ClassLoader getClassLoader() {
            return (ClassLoader)this.m_loaderRef.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassKey)) {
                return false;
            }
            ClassKey classKey = (ClassKey)o;
            ClassLoader loader1 = (ClassLoader)this.m_loaderRef.get();
            ClassLoader loader2 = (ClassLoader)classKey.m_loaderRef.get();
            if (loader1 != null ? !loader1.equals(loader2) : loader2 != null) {
                return false;
            }
            return !(this.m_name != null ? !this.m_name.equals(classKey.m_name) : classKey.m_name != null);
        }

        public int hashCode() {
            int result = this.m_name != null ? this.m_name.hashCode() : 0;
            ClassLoader loader = (ClassLoader)this.m_loaderRef.get();
            result = 29 * result + (loader != null ? loader.hashCode() : 0);
            return result;
        }
    }

    static class AnnotationBuilderVisitor
    implements AnnotationVisitor {
        private final AnnotationElement.NestedAnnotationElement m_nestedAnnotationElement;
        private final ClassLoader m_loader;
        private final String m_annotationClassName;

        public AnnotationBuilderVisitor(AnnotationElement.NestedAnnotationElement annotation, ClassLoader loader, String annotationClassName) {
            this.m_nestedAnnotationElement = annotation;
            this.m_loader = loader;
            this.m_annotationClassName = annotationClassName;
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                this.m_nestedAnnotationElement.addElement(name, value);
            } else if (value.getClass().isArray()) {
                this.handlePrimitiveArrayValue(value, name);
            } else {
                this.m_nestedAnnotationElement.addElement(name, value);
            }
        }

        public void visitEnum(String name, String desc, String value) {
            this.m_nestedAnnotationElement.addElement(name, new AnnotationElement.Enum(desc, value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            String className = AnnotationReader.toJavaName(desc);
            AnnotationElement.Annotation annotation = new AnnotationElement.Annotation(className);
            this.m_nestedAnnotationElement.addElement(name, annotation);
            return new AnnotationBuilderVisitor(annotation, this.m_loader, className);
        }

        public AnnotationVisitor visitArray(String name) {
            AnnotationElement.Array array = new AnnotationElement.Array();
            this.m_nestedAnnotationElement.addElement(name, array);
            return new AnnotationBuilderVisitor(array, this.m_loader, null);
        }

        public void visitEnd() {
            AnnotationElement.Annotation defaults;
            if (this.m_annotationClassName != null && (defaults = AnnotationDefaults.getDefaults(this.m_annotationClassName, this.m_loader)) != null) {
                AnnotationElement.Annotation annotation = (AnnotationElement.Annotation)this.m_nestedAnnotationElement;
                for (AnnotationElement.NamedValue defaultedElement : defaults.getElements()) {
                    annotation.mergeDefaultedElement(defaultedElement);
                }
            }
        }

        private void handlePrimitiveArrayValue(Object value, String name) {
            if (value.getClass().getComponentType().isPrimitive()) {
                if (value instanceof String[]) {
                    this.m_nestedAnnotationElement.addElement(name, value);
                } else {
                    AnnotationElement.Array arrayElement = new AnnotationElement.Array();
                    if (value instanceof int[]) {
                        int[] array = (int[])value;
                        for (int i = 0; i < array.length; ++i) {
                            arrayElement.addElement(null, new Integer(array[i]));
                        }
                    } else if (value instanceof long[]) {
                        long[] array = (long[])value;
                        for (int i = 0; i < array.length; ++i) {
                            arrayElement.addElement(null, new Long(array[i]));
                        }
                    } else if (value instanceof short[]) {
                        short[] array = (short[])value;
                        for (int i = 0; i < array.length; ++i) {
                            arrayElement.addElement(null, new Short(array[i]));
                        }
                    } else if (value instanceof float[]) {
                        float[] array = (float[])value;
                        for (int i = 0; i < array.length; ++i) {
                            arrayElement.addElement(null, new Float(array[i]));
                        }
                    } else if (value instanceof double[]) {
                        double[] array = (double[])value;
                        for (int i = 0; i < array.length; ++i) {
                            arrayElement.addElement(null, new Double(array[i]));
                        }
                    } else if (value instanceof boolean[]) {
                        boolean[] array = (boolean[])value;
                        for (int i = 0; i < array.length; ++i) {
                            arrayElement.addElement(null, new Boolean(array[i]));
                        }
                    } else if (value instanceof byte[]) {
                        byte[] array = (byte[])value;
                        for (int i = 0; i < array.length; ++i) {
                            arrayElement.addElement(null, new Byte(array[i]));
                        }
                    } else if (value instanceof char[]) {
                        char[] array = (char[])value;
                        for (int i = 0; i < array.length; ++i) {
                            arrayElement.addElement(null, new Character(array[i]));
                        }
                    }
                    this.m_nestedAnnotationElement.addElement(name, arrayElement);
                }
            } else {
                this.m_nestedAnnotationElement.addElement(name, value);
            }
        }
    }

    static final class AnnotationRetrievingFieldVisitor
    extends EmptyVisitor {
        private final MemberKey key;
        private final AnnotationReader reader;

        AnnotationRetrievingFieldVisitor(MemberKey key, AnnotationReader reader) {
            this.key = key;
            this.reader = reader;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String className = AnnotationReader.toJavaName(desc);
            AnnotationElement.Annotation annotation = new AnnotationElement.Annotation(className);
            if (this.reader.m_fieldAnnotationElements.containsKey(this.key)) {
                ((Map)this.reader.m_fieldAnnotationElements.get(this.key)).put(className, annotation);
            } else {
                HashMap<String, AnnotationElement.Annotation> annotations = new HashMap<String, AnnotationElement.Annotation>();
                annotations.put(className, annotation);
                this.reader.m_fieldAnnotationElements.put(this.key, annotations);
            }
            return this.reader.createAnnotationVisitor(annotation);
        }
    }

    static final class AnnotationRetrievingMethodVisitor
    extends EmptyVisitor {
        private final MemberKey key;
        private final AnnotationReader reader;

        AnnotationRetrievingMethodVisitor(MemberKey key, AnnotationReader reader) {
            this.key = key;
            this.reader = reader;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String className = AnnotationReader.toJavaName(desc);
            AnnotationElement.Annotation annotation = new AnnotationElement.Annotation(className);
            if (this.reader.m_methodAnnotationElements.containsKey(this.key)) {
                ((Map)this.reader.m_methodAnnotationElements.get(this.key)).put(className, annotation);
            } else {
                HashMap<String, AnnotationElement.Annotation> annotations = new HashMap<String, AnnotationElement.Annotation>();
                annotations.put(className, annotation);
                this.reader.m_methodAnnotationElements.put(this.key, annotations);
            }
            return this.reader.createAnnotationVisitor(annotation);
        }
    }

    static final class AnnotationRetrievingConstructorVisitor
    extends EmptyVisitor {
        private final MemberKey key;
        private final AnnotationReader reader;

        AnnotationRetrievingConstructorVisitor(MemberKey key, AnnotationReader reader) {
            this.key = key;
            this.reader = reader;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String className = AnnotationReader.toJavaName(desc);
            AnnotationElement.Annotation annotation = new AnnotationElement.Annotation(className);
            if (this.reader.m_constructorAnnotationElements.containsKey(this.key)) {
                ((Map)this.reader.m_constructorAnnotationElements.get(this.key)).put(className, annotation);
            } else {
                HashMap<String, AnnotationElement.Annotation> annotations = new HashMap<String, AnnotationElement.Annotation>();
                annotations.put(className, annotation);
                this.reader.m_constructorAnnotationElements.put(this.key, annotations);
            }
            return this.reader.createAnnotationVisitor(annotation);
        }
    }

    class AnnotationRetrievingVisitor
    extends EmptyVisitor {
        AnnotationRetrievingVisitor() {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String annotationClassName = AnnotationReader.toJavaName(desc);
            AnnotationElement.Annotation annotation = new AnnotationElement.Annotation(annotationClassName);
            AnnotationReader.this.m_classAnnotationElements.put(annotationClassName, annotation);
            return AnnotationReader.this.createAnnotationVisitor(annotation);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            MemberKey key = new MemberKey(name, desc);
            return new AnnotationRetrievingFieldVisitor(key, AnnotationReader.this);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MemberKey key = new MemberKey(name, desc);
            if (name.equals(AnnotationReader.INIT_METHOD_NAME)) {
                return new AnnotationRetrievingConstructorVisitor(key, AnnotationReader.this);
            }
            return new AnnotationRetrievingMethodVisitor(key, AnnotationReader.this);
        }
    }
}

