/*
 * Decompiled with CFR 0.152.
 */
package com.tc.backport175.proxy;

import com.tc.backport175.Annotation;
import com.tc.backport175.bytecode.AnnotationElement;
import com.tc.backport175.proxy.JavaDocAnnotationInvocationHander;
import com.tc.backport175.proxy.ResolveAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class ProxyFactory {
    public static Annotation newAnnotationProxy(AnnotationElement.Annotation annotation, ClassLoader loader) {
        Class<?> interfaceClass;
        ClassLoader backportLoader = Annotation.class.getClassLoader();
        if (loader != backportLoader) {
            loader = backportLoader;
        }
        try {
            interfaceClass = Class.forName(annotation.getInterfaceName(), false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new ResolveAnnotationException("annotation interface [" + annotation.getInterfaceName() + "] could not be found");
        }
        JavaDocAnnotationInvocationHander handler = new JavaDocAnnotationInvocationHander(interfaceClass, annotation, loader);
        Object annotationProxy = Proxy.newProxyInstance(loader, new Class[]{Annotation.class, interfaceClass}, (InvocationHandler)handler);
        return (Annotation)annotationProxy;
    }
}

