/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.fullhalf;

import java.util.Set;
import org.terasoluna.gfw.common.fullhalf.FullHalfPair;

public class FullHalfPairs {
    private final Set<FullHalfPair> pairs;
    private final AppendablePredicate predicate;

    public FullHalfPairs(Set<FullHalfPair> pairs, AppendablePredicate predicate) {
        if (pairs == null) {
            throw new IllegalArgumentException("pairs must not be null");
        }
        if (pairs.isEmpty()) {
            throw new IllegalArgumentException("pairs must not be empty");
        }
        this.pairs = pairs;
        this.predicate = predicate != null ? predicate : new AppendablePredicate(){

            @Override
            public boolean isAppendable(char c) {
                return c == '\uff9e' || c == '\uff9f';
            }
        };
    }

    public Set<FullHalfPair> pairs() {
        return this.pairs;
    }

    public AppendablePredicate predicate() {
        return this.predicate;
    }

    public static interface AppendablePredicate {
        public boolean isAppendable(char var1);
    }
}

