/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.schema;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.IntVector;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.lite.schema.SqueezeOptionsT;

public final class SqueezeOptions
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_23_5_26();
    }

    public static SqueezeOptions getRootAsSqueezeOptions(ByteBuffer _bb) {
        return SqueezeOptions.getRootAsSqueezeOptions(_bb, new SqueezeOptions());
    }

    public static SqueezeOptions getRootAsSqueezeOptions(ByteBuffer _bb, SqueezeOptions obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public SqueezeOptions __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int squeezeDims(int j) {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int squeezeDimsLength() {
        int o = this.__offset(4);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector squeezeDimsVector() {
        return this.squeezeDimsVector(new IntVector());
    }

    public IntVector squeezeDimsVector(IntVector obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer squeezeDimsAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 4);
    }

    public ByteBuffer squeezeDimsInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 4);
    }

    public static int createSqueezeOptions(FlatBufferBuilder builder, int squeezeDimsOffset) {
        builder.startTable(1);
        SqueezeOptions.addSqueezeDims(builder, squeezeDimsOffset);
        return SqueezeOptions.endSqueezeOptions(builder);
    }

    public static void startSqueezeOptions(FlatBufferBuilder builder) {
        builder.startTable(1);
    }

    public static void addSqueezeDims(FlatBufferBuilder builder, int squeezeDimsOffset) {
        builder.addOffset(0, squeezeDimsOffset, 0);
    }

    public static int createSqueezeDimsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startSqueezeDimsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endSqueezeOptions(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public SqueezeOptionsT unpack() {
        SqueezeOptionsT _o = new SqueezeOptionsT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(SqueezeOptionsT _o) {
        int[] _oSqueezeDims = new int[this.squeezeDimsLength()];
        for (int _j = 0; _j < this.squeezeDimsLength(); ++_j) {
            _oSqueezeDims[_j] = this.squeezeDims(_j);
        }
        _o.setSqueezeDims(_oSqueezeDims);
    }

    public static int pack(FlatBufferBuilder builder, SqueezeOptionsT _o) {
        if (_o == null) {
            return 0;
        }
        int _squeezeDims = 0;
        if (_o.getSqueezeDims() != null) {
            _squeezeDims = SqueezeOptions.createSqueezeDimsVector(builder, _o.getSqueezeDims());
        }
        return SqueezeOptions.createSqueezeOptions(builder, _squeezeDims);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public SqueezeOptions get(int j) {
            return this.get(new SqueezeOptions(), j);
        }

        public SqueezeOptions get(SqueezeOptions obj, int j) {
            return obj.__assign(SqueezeOptions.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

