/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.schema;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.IntVector;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.lite.schema.DimensionMetadata;
import org.tensorflow.lite.schema.DimensionMetadataT;
import org.tensorflow.lite.schema.SparsityParametersT;

public final class SparsityParameters
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_23_5_26();
    }

    public static SparsityParameters getRootAsSparsityParameters(ByteBuffer _bb) {
        return SparsityParameters.getRootAsSparsityParameters(_bb, new SparsityParameters());
    }

    public static SparsityParameters getRootAsSparsityParameters(ByteBuffer _bb, SparsityParameters obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public SparsityParameters __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int traversalOrder(int j) {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int traversalOrderLength() {
        int o = this.__offset(4);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector traversalOrderVector() {
        return this.traversalOrderVector(new IntVector());
    }

    public IntVector traversalOrderVector(IntVector obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer traversalOrderAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 4);
    }

    public ByteBuffer traversalOrderInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 4);
    }

    public int blockMap(int j) {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int blockMapLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector blockMapVector() {
        return this.blockMapVector(new IntVector());
    }

    public IntVector blockMapVector(IntVector obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer blockMapAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 4);
    }

    public ByteBuffer blockMapInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 4);
    }

    public DimensionMetadata dimMetadata(int j) {
        return this.dimMetadata(new DimensionMetadata(), j);
    }

    public DimensionMetadata dimMetadata(DimensionMetadata obj, int j) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int dimMetadataLength() {
        int o = this.__offset(8);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public DimensionMetadata.Vector dimMetadataVector() {
        return this.dimMetadataVector(new DimensionMetadata.Vector());
    }

    public DimensionMetadata.Vector dimMetadataVector(DimensionMetadata.Vector obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public static int createSparsityParameters(FlatBufferBuilder builder, int traversalOrderOffset, int blockMapOffset, int dimMetadataOffset) {
        builder.startTable(3);
        SparsityParameters.addDimMetadata(builder, dimMetadataOffset);
        SparsityParameters.addBlockMap(builder, blockMapOffset);
        SparsityParameters.addTraversalOrder(builder, traversalOrderOffset);
        return SparsityParameters.endSparsityParameters(builder);
    }

    public static void startSparsityParameters(FlatBufferBuilder builder) {
        builder.startTable(3);
    }

    public static void addTraversalOrder(FlatBufferBuilder builder, int traversalOrderOffset) {
        builder.addOffset(0, traversalOrderOffset, 0);
    }

    public static int createTraversalOrderVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startTraversalOrderVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addBlockMap(FlatBufferBuilder builder, int blockMapOffset) {
        builder.addOffset(1, blockMapOffset, 0);
    }

    public static int createBlockMapVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startBlockMapVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addDimMetadata(FlatBufferBuilder builder, int dimMetadataOffset) {
        builder.addOffset(2, dimMetadataOffset, 0);
    }

    public static int createDimMetadataVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startDimMetadataVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endSparsityParameters(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public SparsityParametersT unpack() {
        SparsityParametersT _o = new SparsityParametersT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(SparsityParametersT _o) {
        int[] _oTraversalOrder = new int[this.traversalOrderLength()];
        for (int _j = 0; _j < this.traversalOrderLength(); ++_j) {
            _oTraversalOrder[_j] = this.traversalOrder(_j);
        }
        _o.setTraversalOrder(_oTraversalOrder);
        int[] _oBlockMap = new int[this.blockMapLength()];
        for (int _j = 0; _j < this.blockMapLength(); ++_j) {
            _oBlockMap[_j] = this.blockMap(_j);
        }
        _o.setBlockMap(_oBlockMap);
        DimensionMetadataT[] _oDimMetadata = new DimensionMetadataT[this.dimMetadataLength()];
        for (int _j = 0; _j < this.dimMetadataLength(); ++_j) {
            _oDimMetadata[_j] = this.dimMetadata(_j) != null ? this.dimMetadata(_j).unpack() : null;
        }
        _o.setDimMetadata(_oDimMetadata);
    }

    public static int pack(FlatBufferBuilder builder, SparsityParametersT _o) {
        if (_o == null) {
            return 0;
        }
        int _traversalOrder = 0;
        if (_o.getTraversalOrder() != null) {
            _traversalOrder = SparsityParameters.createTraversalOrderVector(builder, _o.getTraversalOrder());
        }
        int _blockMap = 0;
        if (_o.getBlockMap() != null) {
            _blockMap = SparsityParameters.createBlockMapVector(builder, _o.getBlockMap());
        }
        int _dimMetadata = 0;
        if (_o.getDimMetadata() != null) {
            int[] __dimMetadata = new int[_o.getDimMetadata().length];
            int _j = 0;
            for (DimensionMetadataT _e : _o.getDimMetadata()) {
                __dimMetadata[_j] = DimensionMetadata.pack(builder, _e);
                ++_j;
            }
            _dimMetadata = SparsityParameters.createDimMetadataVector(builder, __dimMetadata);
        }
        return SparsityParameters.createSparsityParameters(builder, _traversalOrder, _blockMap, _dimMetadata);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public SparsityParameters get(int j) {
            return this.get(new SparsityParameters(), j);
        }

        public SparsityParameters get(SparsityParameters obj, int j) {
            return obj.__assign(SparsityParameters.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

