/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.schema;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.IntVector;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.lite.schema.Int32VectorT;

public final class Int32Vector
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_0();
    }

    public static Int32Vector getRootAsInt32Vector(ByteBuffer _bb) {
        return Int32Vector.getRootAsInt32Vector(_bb, new Int32Vector());
    }

    public static Int32Vector getRootAsInt32Vector(ByteBuffer _bb, Int32Vector obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public Int32Vector __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public int values(int j) {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int valuesLength() {
        int o = this.__offset(4);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector valuesVector() {
        return this.valuesVector(new IntVector());
    }

    public IntVector valuesVector(IntVector obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer valuesAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 4);
    }

    public ByteBuffer valuesInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 4);
    }

    public static int createInt32Vector(FlatBufferBuilder builder, int valuesOffset) {
        builder.startTable(1);
        Int32Vector.addValues(builder, valuesOffset);
        return Int32Vector.endInt32Vector(builder);
    }

    public static void startInt32Vector(FlatBufferBuilder builder) {
        builder.startTable(1);
    }

    public static void addValues(FlatBufferBuilder builder, int valuesOffset) {
        builder.addOffset(0, valuesOffset, 0);
    }

    public static int createValuesVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startValuesVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endInt32Vector(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public Int32VectorT unpack() {
        Int32VectorT _o = new Int32VectorT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(Int32VectorT _o) {
        int[] _oValues = new int[this.valuesLength()];
        for (int _j = 0; _j < this.valuesLength(); ++_j) {
            _oValues[_j] = this.values(_j);
        }
        _o.setValues(_oValues);
    }

    public static int pack(FlatBufferBuilder builder, Int32VectorT _o) {
        if (_o == null) {
            return 0;
        }
        int _values = 0;
        if (_o.getValues() != null) {
            _values = Int32Vector.createValuesVector(builder, _o.getValues());
        }
        return Int32Vector.createInt32Vector(builder, _values);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public Int32Vector get(int j) {
            return this.get(new Int32Vector(), j);
        }

        public Int32Vector get(Int32Vector obj, int j) {
            return obj.__assign(Int32Vector.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

