/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sequence;

import java.util.Iterator;
import java.util.function.BiConsumer;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArraySequence;
import org.tensorflow.ndarray.impl.AbstractNdArray;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.sequence.PositionIterator;

public final class SlicingElementSequence<T, U extends NdArray<T>>
implements NdArraySequence<U> {
    private final AbstractNdArray<T, U> ndArray;
    private final int dimensionIdx;
    private final DimensionalSpace elementDimensions;

    public SlicingElementSequence(AbstractNdArray<T, U> ndArray, int dimensionIdx) {
        this(ndArray, dimensionIdx, ndArray.dimensions().from(dimensionIdx + 1));
    }

    public SlicingElementSequence(AbstractNdArray<T, U> ndArray, int dimensionIdx, DimensionalSpace elementDimensions) {
        this.ndArray = ndArray;
        this.dimensionIdx = dimensionIdx;
        this.elementDimensions = elementDimensions;
    }

    @Override
    public Iterator<U> iterator() {
        final PositionIterator positionIterator = PositionIterator.create(this.ndArray.dimensions(), this.dimensionIdx);
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return positionIterator.hasNext();
            }

            @Override
            public U next() {
                return SlicingElementSequence.this.ndArray.slice(positionIterator.next(), SlicingElementSequence.this.elementDimensions);
            }
        };
    }

    @Override
    public void forEachIndexed(BiConsumer<long[], U> consumer) {
        PositionIterator.createIndexed(this.ndArray.dimensions(), this.dimensionIdx).forEachIndexed((long[] coords, long position) -> consumer.accept(coords, this.ndArray.slice(position, this.elementDimensions)));
    }

    @Override
    public NdArraySequence<U> asSlices() {
        return this;
    }
}

