/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sequence;

import java.util.Iterator;
import java.util.function.BiConsumer;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArraySequence;
import org.tensorflow.ndarray.buffer.DataBufferWindow;
import org.tensorflow.ndarray.impl.AbstractNdArray;
import org.tensorflow.ndarray.impl.sequence.PositionIterator;
import org.tensorflow.ndarray.impl.sequence.SlicingElementSequence;

public final class FastElementSequence<T, U extends NdArray<T>>
implements NdArraySequence<U> {
    private final AbstractNdArray<T, U> ndArray;
    private final int dimensionIdx;
    private final U element;
    private final DataBufferWindow<?> elementWindow;

    public FastElementSequence(AbstractNdArray<T, U> ndArray, int dimensionIdx, U element, DataBufferWindow<?> elementWindow) {
        this.ndArray = ndArray;
        this.dimensionIdx = dimensionIdx;
        this.element = element;
        this.elementWindow = elementWindow;
    }

    @Override
    public Iterator<U> iterator() {
        return new SequenceIterator();
    }

    @Override
    public void forEachIndexed(BiConsumer<long[], U> consumer) {
        PositionIterator.createIndexed(this.ndArray.dimensions(), this.dimensionIdx).forEachIndexed((long[] coords, long position) -> {
            this.elementWindow.slideTo(position);
            consumer.accept(coords, this.element);
        });
    }

    @Override
    public NdArraySequence<U> asSlices() {
        return new SlicingElementSequence<T, U>(this.ndArray, this.dimensionIdx);
    }

    private class SequenceIterator
    implements Iterator<U> {
        private final PositionIterator positionIterator;

        private SequenceIterator() {
            this.positionIterator = PositionIterator.create(FastElementSequence.this.ndArray.dimensions(), FastElementSequence.this.dimensionIdx);
        }

        @Override
        public boolean hasNext() {
            return this.positionIterator.hasNext();
        }

        @Override
        public U next() {
            FastElementSequence.this.elementWindow.slideTo(this.positionIterator.nextLong());
            return FastElementSequence.this.element;
        }
    }
}

