/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.misc;

import java.util.Arrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataStorageVisitor;
import org.tensorflow.ndarray.impl.buffer.AbstractDataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;

class ArrayDataBuffer<T>
extends AbstractDataBuffer<T> {
    private final T[] values;
    private final boolean readOnly;
    private final int offset;
    private final int length;

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public T getObject(long index) {
        Validator.getArgs(this, index);
        return this.values[(int)index + this.offset];
    }

    @Override
    public DataBuffer<T> setObject(T value, long index) {
        Validator.setArgs(this, index);
        this.values[(int)index + this.offset] = value;
        return this;
    }

    @Override
    public DataBuffer<T> copyTo(final DataBuffer<T> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return (DataBuffer)dst.accept(new DataStorageVisitor<DataBuffer<T>>(){

            @Override
            public DataBuffer<T> visit(Object[] array, int arrayOffset, int arrayLength) {
                System.arraycopy(ArrayDataBuffer.this.values, ArrayDataBuffer.this.offset, array, arrayOffset, (int)size);
                return ArrayDataBuffer.this;
            }

            @Override
            public DataBuffer<T> fallback() {
                int idx = 0;
                while ((long)idx < size) {
                    dst.setObject(ArrayDataBuffer.this.values[idx + ArrayDataBuffer.this.offset], idx);
                    ++idx;
                }
                return ArrayDataBuffer.this;
            }
        });
    }

    @Override
    public DataBuffer<T> slice(long index, long size) {
        Validator.sliceArgs(this, index, size);
        return new ArrayDataBuffer<T>(this.values, this.readOnly, this.offset + (int)index, (int)size);
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        return visitor.visit(this.values, this.offset, this.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataBuffer)) {
            return false;
        }
        final DataBuffer other = (DataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(Object[] array, int arrayOffset, int arrayLength) {
                if (ArrayDataBuffer.this.offset == 0 && ArrayDataBuffer.this.values.length == ArrayDataBuffer.this.length && arrayOffset == 0 && array.length == arrayLength) {
                    return Arrays.deepEquals(array, ArrayDataBuffer.this.values);
                }
                return ArrayDataBuffer.this.slowEquals(other);
            }

            @Override
            public Boolean fallback() {
                return ArrayDataBuffer.this.slowEquals(other);
            }
        });
    }

    ArrayDataBuffer(T[] values, boolean readOnly) {
        this(values, readOnly, 0, values.length);
    }

    private ArrayDataBuffer(T[] values, boolean readOnly, int offset, int length) {
        this.values = values;
        this.readOnly = readOnly;
        this.offset = offset;
        this.length = length;
    }
}

