/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FakeQuantWithMinMaxVarsPerChannel
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> outputs;

    public static FakeQuantWithMinMaxVarsPerChannel create(Scope scope, Operand<Float> inputs, Operand<Float> min, Operand<Float> max, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("FakeQuantWithMinMaxVarsPerChannel", scope.makeOpName("FakeQuantWithMinMaxVarsPerChannel"));
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(min.asOutput());
        opBuilder.addInput(max.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.narrowRange == null) continue;
                opBuilder.setAttr("narrow_range", opts.narrowRange);
            }
        }
        return new FakeQuantWithMinMaxVarsPerChannel(opBuilder.build());
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public Output<Float> outputs() {
        return this.outputs;
    }

    @Override
    public Output<Float> asOutput() {
        return this.outputs;
    }

    private FakeQuantWithMinMaxVarsPerChannel(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputs = operation.output(outputIdx++);
    }

    public static class Options {
        private Long numBits;
        private Boolean narrowRange;

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        private Options() {
        }
    }
}

