/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class AudioSpectrogram
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> spectrogram;

    public static AudioSpectrogram create(Scope scope, Operand<Float> input, Long windowSize, Long stride, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("AudioSpectrogram", scope.makeOpName("AudioSpectrogram"));
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("window_size", windowSize);
        opBuilder.setAttr("stride", stride);
        if (options != null) {
            for (Options opts : options) {
                if (opts.magnitudeSquared == null) continue;
                opBuilder.setAttr("magnitude_squared", opts.magnitudeSquared);
            }
        }
        return new AudioSpectrogram(opBuilder.build());
    }

    public static Options magnitudeSquared(Boolean magnitudeSquared) {
        return new Options().magnitudeSquared(magnitudeSquared);
    }

    public Output<Float> spectrogram() {
        return this.spectrogram;
    }

    @Override
    public Output<Float> asOutput() {
        return this.spectrogram;
    }

    private AudioSpectrogram(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.spectrogram = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean magnitudeSquared;

        public Options magnitudeSquared(Boolean magnitudeSquared) {
            this.magnitudeSquared = magnitudeSquared;
            return this;
        }

        private Options() {
        }
    }
}

