/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.tensorflow.DataType;
import org.tensorflow.TensorFlow;

public final class Tensor<T>
implements AutoCloseable {
    private long nativeHandle;
    private DataType dtype;
    private long[] shapeCopy = null;
    private static HashMap<Class<?>, DataType> classDataTypes = new HashMap();

    public static <T> Tensor<T> create(Object obj, Class<T> type) {
        DataType dtype = DataType.fromClass(type);
        if (!Tensor.objectCompatWithType(obj, dtype)) {
            throw new IllegalArgumentException("DataType of object does not match T (expected " + (Object)((Object)dtype) + ", got " + (Object)((Object)Tensor.dataTypeOf(obj)) + ")");
        }
        return Tensor.create(obj, dtype);
    }

    public static Tensor<?> create(Object obj) {
        return Tensor.create(obj, Tensor.dataTypeOf(obj));
    }

    private static Tensor<?> create(Object obj, DataType dtype) {
        Tensor t = new Tensor(dtype);
        t.shapeCopy = new long[Tensor.numDimensions(obj, dtype)];
        Tensor.fillShape(obj, 0, t.shapeCopy);
        if (t.dtype != DataType.STRING) {
            int byteSize = Tensor.elemByteSize(t.dtype) * Tensor.numElements(t.shapeCopy);
            t.nativeHandle = Tensor.allocate(t.dtype.c(), t.shapeCopy, byteSize);
            Tensor.setValue(t.nativeHandle, obj);
        } else {
            t.nativeHandle = t.shapeCopy.length != 0 ? Tensor.allocateNonScalarBytes(t.shapeCopy, (Object[])obj) : Tensor.allocateScalarBytes((byte[])obj);
        }
        return t;
    }

    public static Tensor<Integer> create(long[] shape, IntBuffer data) {
        Tensor<Integer> t = Tensor.allocateForBuffer(DataType.INT32, shape, data.remaining());
        super.buffer().asIntBuffer().put(data);
        return t;
    }

    public static Tensor<Float> create(long[] shape, FloatBuffer data) {
        Tensor<Float> t = Tensor.allocateForBuffer(DataType.FLOAT, shape, data.remaining());
        super.buffer().asFloatBuffer().put(data);
        return t;
    }

    public static Tensor<Double> create(long[] shape, DoubleBuffer data) {
        Tensor<Double> t = Tensor.allocateForBuffer(DataType.DOUBLE, shape, data.remaining());
        super.buffer().asDoubleBuffer().put(data);
        return t;
    }

    public static Tensor<Long> create(long[] shape, LongBuffer data) {
        Tensor<Long> t = Tensor.allocateForBuffer(DataType.INT64, shape, data.remaining());
        super.buffer().asLongBuffer().put(data);
        return t;
    }

    public static <T> Tensor<T> create(Class<T> type, long[] shape, ByteBuffer data) {
        Tensor<?> ret = Tensor.create(DataType.fromClass(type), shape, data);
        return ret;
    }

    private static Tensor<?> create(DataType dtype, long[] shape, ByteBuffer data) {
        int nremaining = 0;
        if (dtype != DataType.STRING) {
            int elemBytes = Tensor.elemByteSize(dtype);
            if (data.remaining() % elemBytes != 0) {
                throw new IllegalArgumentException(String.format("ByteBuffer with %d bytes is not compatible with a %s Tensor (%d bytes/element)", data.remaining(), dtype.toString(), elemBytes));
            }
            nremaining = data.remaining() / elemBytes;
        } else {
            nremaining = data.remaining();
        }
        Tensor t = Tensor.allocateForBuffer(dtype, shape, nremaining);
        super.buffer().put(data);
        return t;
    }

    public <U> Tensor<U> expect(Class<U> type) {
        DataType dt = DataType.fromClass(type);
        if (!dt.equals((Object)this.dtype)) {
            throw new IllegalArgumentException("Cannot cast from tensor of " + (Object)((Object)this.dtype) + " to tensor of " + (Object)((Object)dt));
        }
        return this;
    }

    private static <T> Tensor<T> allocateForBuffer(DataType dataType, long[] shape, int nBuffered) {
        int nflattened = Tensor.numElements(shape);
        int nbytes = 0;
        if (dataType != DataType.STRING) {
            if (nBuffered != nflattened) {
                throw Tensor.incompatibleBuffer(nBuffered, shape);
            }
            nbytes = nflattened * Tensor.elemByteSize(dataType);
        } else {
            nbytes = nBuffered;
        }
        Tensor<T> t = new Tensor<T>(dataType);
        t.shapeCopy = Arrays.copyOf(shape, shape.length);
        t.nativeHandle = Tensor.allocate(t.dtype.c(), t.shapeCopy, nbytes);
        return t;
    }

    @Override
    public void close() {
        if (this.nativeHandle != 0L) {
            Tensor.delete(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    public DataType dataType() {
        return this.dtype;
    }

    public int numDimensions() {
        return this.shapeCopy.length;
    }

    public int numBytes() {
        return this.buffer().remaining();
    }

    public int numElements() {
        return Tensor.numElements(this.shapeCopy);
    }

    public long[] shape() {
        return this.shapeCopy;
    }

    public float floatValue() {
        return Tensor.scalarFloat(this.nativeHandle);
    }

    public double doubleValue() {
        return Tensor.scalarDouble(this.nativeHandle);
    }

    public int intValue() {
        return Tensor.scalarInt(this.nativeHandle);
    }

    public long longValue() {
        return Tensor.scalarLong(this.nativeHandle);
    }

    public boolean booleanValue() {
        return Tensor.scalarBoolean(this.nativeHandle);
    }

    public byte[] bytesValue() {
        return Tensor.scalarBytes(this.nativeHandle);
    }

    public <U> U copyTo(U dst) {
        this.throwExceptionIfTypeIsIncompatible(dst);
        Tensor.readNDArray(this.nativeHandle, dst);
        return dst;
    }

    public void writeTo(IntBuffer dst) {
        if (this.dtype != DataType.INT32) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer src = this.buffer();
        dst.put(src.asIntBuffer());
    }

    public void writeTo(FloatBuffer dst) {
        if (this.dtype != DataType.FLOAT) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer src = this.buffer();
        dst.put(src.asFloatBuffer());
    }

    public void writeTo(DoubleBuffer dst) {
        if (this.dtype != DataType.DOUBLE) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer src = this.buffer();
        dst.put(src.asDoubleBuffer());
    }

    public void writeTo(LongBuffer dst) {
        if (this.dtype != DataType.INT64) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer src = this.buffer();
        dst.put(src.asLongBuffer());
    }

    public void writeTo(ByteBuffer dst) {
        ByteBuffer src = this.buffer();
        dst.put(src);
    }

    public String toString() {
        return String.format("%s tensor with shape %s", this.dtype.toString(), Arrays.toString(this.shape()));
    }

    static Tensor<?> fromHandle(long handle) {
        Tensor t = new Tensor(DataType.fromC(Tensor.dtype(handle)));
        t.shapeCopy = Tensor.shape(handle);
        t.nativeHandle = handle;
        return t;
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    private Tensor(DataType t) {
        this.dtype = t;
    }

    private ByteBuffer buffer() {
        return Tensor.buffer(this.nativeHandle).order(ByteOrder.nativeOrder());
    }

    private static IllegalArgumentException incompatibleBuffer(Buffer buf, DataType dataType) {
        return new IllegalArgumentException(String.format("cannot use %s with Tensor of type %s", new Object[]{buf.getClass().getName(), dataType}));
    }

    private static IllegalArgumentException incompatibleBuffer(int numElements, long[] shape) {
        return new IllegalArgumentException(String.format("buffer with %d elements is not compatible with a Tensor with shape %s", numElements, Arrays.toString(shape)));
    }

    private static int numElements(long[] shape) {
        int n = 1;
        for (int i = 0; i < shape.length; ++i) {
            n *= (int)shape[i];
        }
        return n;
    }

    private static int elemByteSize(DataType dataType) {
        switch (dataType) {
            case FLOAT: 
            case INT32: {
                return 4;
            }
            case DOUBLE: 
            case INT64: {
                return 8;
            }
            case BOOL: 
            case UINT8: {
                return 1;
            }
            case STRING: {
                throw new IllegalArgumentException("STRING tensors do not have a fixed element size");
            }
        }
        throw new IllegalArgumentException("DataType " + (Object)((Object)dataType) + " is not supported yet");
    }

    private static void throwExceptionIfNotByteOfByteArrays(Object array) {
        if (!array.getClass().getName().equals("[[B")) {
            throw new IllegalArgumentException("object cannot be converted to a Tensor as it includes an array with null elements");
        }
    }

    private static Class<?> baseObjType(Object o) {
        Class<?> c = o.getClass();
        while (c.isArray()) {
            c = c.getComponentType();
        }
        return c;
    }

    private static DataType dataTypeOf(Object o) {
        Class<?> c = Tensor.baseObjType(o);
        return Tensor.dataTypeFromClass(c);
    }

    private static DataType dataTypeFromClass(Class<?> c) {
        DataType ret = classDataTypes.get(c);
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("cannot create Tensors of type " + c.getName());
    }

    private static int numDimensions(Object o, DataType dtype) {
        int ret = Tensor.numArrayDimensions(o);
        if (dtype == DataType.STRING && ret > 0) {
            return ret - 1;
        }
        return ret;
    }

    private static int numArrayDimensions(Object o) {
        Class<?> c = o.getClass();
        int i = 0;
        while (c.isArray()) {
            c = c.getComponentType();
            ++i;
        }
        return i;
    }

    private static void fillShape(Object o, int dim, long[] shape) {
        if (shape == null || dim == shape.length) {
            return;
        }
        int len = Array.getLength(o);
        if (len == 0) {
            throw new IllegalArgumentException("cannot create Tensors with a 0 dimension");
        }
        if (shape[dim] == 0L) {
            shape[dim] = len;
        } else if (shape[dim] != (long)len) {
            throw new IllegalArgumentException(String.format("mismatched lengths (%d and %d) in dimension %d", shape[dim], len, dim));
        }
        for (int i = 0; i < len; ++i) {
            Tensor.fillShape(Array.get(o, i), dim + 1, shape);
        }
    }

    private static boolean objectCompatWithType(Object obj, DataType dtype) {
        Class<?> c = Tensor.baseObjType(obj);
        DataType dto = Tensor.dataTypeFromClass(c);
        int nd = Tensor.numDimensions(obj, dto);
        if (!c.isPrimitive() && c != String.class && nd != 0) {
            throw new IllegalArgumentException("cannot create non-scalar Tensors from arrays of boxed values");
        }
        if (dto.equals((Object)dtype)) {
            return true;
        }
        return dto == DataType.STRING && dtype == DataType.UINT8;
    }

    private void throwExceptionIfTypeIsIncompatible(Object o) {
        int rank = this.numDimensions();
        int oRank = Tensor.numDimensions(o, this.dtype);
        if (oRank != rank) {
            throw new IllegalArgumentException(String.format("cannot copy Tensor with %d dimensions into an object with %d", rank, oRank));
        }
        if (!Tensor.objectCompatWithType(o, this.dtype)) {
            throw new IllegalArgumentException(String.format("cannot copy Tensor with DataType %s into an object of type %s", this.dtype.toString(), o.getClass().getName()));
        }
        long[] oShape = new long[rank];
        Tensor.fillShape(o, 0, oShape);
        for (int i = 0; i < oShape.length; ++i) {
            if (oShape[i] == this.shape()[i]) continue;
            throw new IllegalArgumentException(String.format("cannot copy Tensor with shape %s into object with shape %s", Arrays.toString(this.shape()), Arrays.toString(oShape)));
        }
    }

    private static native long allocate(int var0, long[] var1, long var2);

    private static native long allocateScalarBytes(byte[] var0);

    private static native long allocateNonScalarBytes(long[] var0, Object[] var1);

    private static native void delete(long var0);

    private static native ByteBuffer buffer(long var0);

    private static native int dtype(long var0);

    private static native long[] shape(long var0);

    private static native void setValue(long var0, Object var2);

    private static native float scalarFloat(long var0);

    private static native double scalarDouble(long var0);

    private static native int scalarInt(long var0);

    private static native long scalarLong(long var0);

    private static native boolean scalarBoolean(long var0);

    private static native byte[] scalarBytes(long var0);

    private static native void readNDArray(long var0, Object var2);

    static {
        classDataTypes.put(Integer.TYPE, DataType.INT32);
        classDataTypes.put(Integer.class, DataType.INT32);
        classDataTypes.put(Long.TYPE, DataType.INT64);
        classDataTypes.put(Long.class, DataType.INT64);
        classDataTypes.put(Float.TYPE, DataType.FLOAT);
        classDataTypes.put(Float.class, DataType.FLOAT);
        classDataTypes.put(Double.TYPE, DataType.DOUBLE);
        classDataTypes.put(Double.class, DataType.DOUBLE);
        classDataTypes.put(Byte.TYPE, DataType.STRING);
        classDataTypes.put(Byte.class, DataType.STRING);
        classDataTypes.put(Boolean.TYPE, DataType.BOOL);
        classDataTypes.put(Boolean.class, DataType.BOOL);
        TensorFlow.init();
    }
}

