/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tensorflow.TensorFlow;

final class NativeLibrary {
    private static final boolean DEBUG = System.getProperty("org.tensorflow.NativeLibrary.DEBUG") != null;
    private static final String JNI_LIBNAME = "tensorflow_jni";
    private static final String FRAMEWORK_LIBNAME = "tensorflow_framework";

    public static void load() {
        if (NativeLibrary.isLoaded() || NativeLibrary.tryLoadLibrary()) {
            return;
        }
        String jniResourceName = NativeLibrary.makeResourceName(JNI_LIBNAME);
        NativeLibrary.log("jniResourceName: " + jniResourceName);
        InputStream jniResource = NativeLibrary.class.getClassLoader().getResourceAsStream(jniResourceName);
        String frameworkResourceName = NativeLibrary.makeResourceName(FRAMEWORK_LIBNAME);
        NativeLibrary.log("frameworkResourceName: " + frameworkResourceName);
        InputStream frameworkResource = NativeLibrary.class.getClassLoader().getResourceAsStream(frameworkResourceName);
        if (jniResource == null) {
            throw new UnsatisfiedLinkError(String.format("Cannot find TensorFlow native library for OS: %s, architecture: %s. See https://github.com/tensorflow/tensorflow/tree/master/tensorflow/java/README.md for possible solutions (such as building the library from source). Additional information on attempts to find the native library can be obtained by adding org.tensorflow.NativeLibrary.DEBUG=1 to the system properties of the JVM.", NativeLibrary.os(), NativeLibrary.architecture()));
        }
        try {
            File tempPath = NativeLibrary.createTemporaryDirectory();
            tempPath.deleteOnExit();
            String tempDirectory = tempPath.toString();
            if (frameworkResource != null) {
                NativeLibrary.extractResource(frameworkResource, FRAMEWORK_LIBNAME, tempDirectory);
            } else {
                NativeLibrary.log(frameworkResourceName + " not found. This is fine assuming " + jniResourceName + " is not built to depend on it.");
            }
            System.load(NativeLibrary.extractResource(jniResource, JNI_LIBNAME, tempDirectory));
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError(String.format("Unable to extract native library into a temporary file (%s)", e.toString()));
        }
    }

    private static boolean tryLoadLibrary() {
        try {
            System.loadLibrary(JNI_LIBNAME);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            NativeLibrary.log("tryLoadLibraryFailed: " + e.getMessage());
            return false;
        }
    }

    private static boolean isLoaded() {
        try {
            TensorFlow.version();
            NativeLibrary.log("isLoaded: true");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    private static String extractResource(InputStream resource, String resourceName, String extractToDirectory) throws IOException {
        File dst = new File(extractToDirectory, System.mapLibraryName(resourceName));
        dst.deleteOnExit();
        String dstPath = dst.toString();
        NativeLibrary.log("extracting native library to: " + dstPath);
        long nbytes = NativeLibrary.copy(resource, dst);
        NativeLibrary.log(String.format("copied %d bytes to %s", nbytes, dstPath));
        return dstPath;
    }

    private static String os() {
        String p = System.getProperty("os.name").toLowerCase();
        if (p.contains("linux")) {
            return "linux";
        }
        if (p.contains("os x") || p.contains("darwin")) {
            return "darwin";
        }
        if (p.contains("windows")) {
            return "windows";
        }
        return p.replaceAll("\\s", "");
    }

    private static String architecture() {
        String arch = System.getProperty("os.arch").toLowerCase();
        return arch.equals("amd64") ? "x86_64" : arch;
    }

    private static void log(String msg) {
        if (DEBUG) {
            System.err.println("org.tensorflow.NativeLibrary: " + msg);
        }
    }

    private static String makeResourceName(String baseName) {
        return "org/tensorflow/native/" + String.format("%s-%s/", NativeLibrary.os(), NativeLibrary.architecture()) + System.mapLibraryName(baseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream src, File dstFile) throws IOException {
        FileOutputStream dst = new FileOutputStream(dstFile);
        try {
            byte[] buffer = new byte[0x100000];
            long ret = 0L;
            int n = 0;
            while ((n = src.read(buffer)) >= 0) {
                dst.write(buffer, 0, n);
                ret += (long)n;
            }
            long l = ret;
            return l;
        }
        finally {
            dst.close();
            src.close();
        }
    }

    private static File createTemporaryDirectory() {
        File baseDirectory = new File(System.getProperty("java.io.tmpdir"));
        String directoryName = "tensorflow_native_libraries-" + System.currentTimeMillis() + "-";
        for (int attempt = 0; attempt < 1000; ++attempt) {
            File temporaryDirectory = new File(baseDirectory, directoryName + attempt);
            if (!temporaryDirectory.mkdir()) continue;
            return temporaryDirectory;
        }
        throw new IllegalStateException("Could not create a temporary directory (tried to make " + directoryName + "*) to extract TensorFlow native libraries.");
    }

    private NativeLibrary() {
    }
}

