/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.tensorflow.DataType;
import org.tensorflow.Graph;
import org.tensorflow.Output;

public final class Operation {
    private final long unsafeNativeHandle;
    private final Graph graph;

    Operation(Graph g, long unsafeNativeHandle) {
        this.graph = g;
        this.unsafeNativeHandle = unsafeNativeHandle;
    }

    public String name() {
        try (Graph.Reference r = this.graph.ref();){
            String string = Operation.name(this.unsafeNativeHandle);
            return string;
        }
    }

    public String type() {
        try (Graph.Reference r = this.graph.ref();){
            String string = Operation.type(this.unsafeNativeHandle);
            return string;
        }
    }

    public int numOutputs() {
        try (Graph.Reference r = this.graph.ref();){
            int n = Operation.numOutputs(this.unsafeNativeHandle);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int outputListLength(String name) {
        try (Graph.Reference r = this.graph.ref();){
            int n = Operation.outputListLength(this.unsafeNativeHandle, name);
            return n;
        }
    }

    public Output<?>[] outputList(int idx, int length) {
        Output[] outputs = new Output[length];
        for (int i = 0; i < length; ++i) {
            outputs[i] = this.output(idx + i);
        }
        return outputs;
    }

    public <T> Output<T> output(int idx) {
        return new Output(this, idx);
    }

    public int hashCode() {
        return Long.valueOf(this.unsafeNativeHandle).hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Operation)) {
            return false;
        }
        Operation that = (Operation)o;
        if (this.graph != that.graph) {
            return false;
        }
        try (Graph.Reference r = this.graph.ref();){
            boolean bl = this.unsafeNativeHandle == that.unsafeNativeHandle;
            return bl;
        }
    }

    public String toString() {
        return String.format("<%s '%s'>", this.type(), this.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inputListLength(String name) {
        try (Graph.Reference r = this.graph.ref();){
            int n = Operation.inputListLength(this.unsafeNativeHandle, name);
            return n;
        }
    }

    long getUnsafeNativeHandle() {
        return this.unsafeNativeHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] shape(int output) {
        try (Graph.Reference r = this.graph.ref();){
            long[] lArray = Operation.shape(r.nativeHandle(), this.unsafeNativeHandle, output);
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataType dtype(int output) {
        try (Graph.Reference r = this.graph.ref();){
            DataType dataType = DataType.fromC(Operation.dtype(r.nativeHandle(), this.unsafeNativeHandle, output));
            return dataType;
        }
    }

    private static native String name(long var0);

    private static native String type(long var0);

    private static native int numOutputs(long var0);

    private static native int outputListLength(long var0, String var2);

    private static native int inputListLength(long var0, String var2);

    private static native long[] shape(long var0, long var2, int var4);

    private static native int dtype(long var0, long var2, int var4);
}

