/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SplitV<T>
extends PrimitiveOp
implements Iterable<Operand<T>> {
    private List<Output<T>> output;

    public static <T, U extends Number> SplitV<T> create(Scope scope, Operand<T> value, Operand<U> sizeSplits, Operand<Integer> axis, Long numSplit) {
        OperationBuilder opBuilder = scope.graph().opBuilder("SplitV", scope.makeOpName("SplitV"));
        opBuilder.addInput(value.asOutput());
        opBuilder.addInput(sizeSplits.asOutput());
        opBuilder.addInput(axis.asOutput());
        opBuilder.setAttr("num_split", numSplit);
        return new SplitV<T>(opBuilder.build());
    }

    public List<Output<T>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    private SplitV(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }
}

