/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BoostedTreesCalculateBestGainsPerFeature
extends PrimitiveOp {
    private List<Output<Integer>> nodeIdsList;
    private List<Output<Float>> gainsList;
    private List<Output<Integer>> thresholdsList;
    private List<Output<Float>> leftNodeContribsList;
    private List<Output<Float>> rightNodeContribsList;

    public static BoostedTreesCalculateBestGainsPerFeature create(Scope scope, Operand<Integer> nodeIdRange, Iterable<Operand<Float>> statsSummaryList, Operand<Float> l1, Operand<Float> l2, Operand<Float> treeComplexity, Operand<Float> minNodeWeight, Long maxSplits) {
        OperationBuilder opBuilder = scope.graph().opBuilder("BoostedTreesCalculateBestGainsPerFeature", scope.makeOpName("BoostedTreesCalculateBestGainsPerFeature"));
        opBuilder.addInput(nodeIdRange.asOutput());
        opBuilder.addInputList(Operands.asOutputs(statsSummaryList));
        opBuilder.addInput(l1.asOutput());
        opBuilder.addInput(l2.asOutput());
        opBuilder.addInput(treeComplexity.asOutput());
        opBuilder.addInput(minNodeWeight.asOutput());
        opBuilder.setAttr("max_splits", maxSplits);
        return new BoostedTreesCalculateBestGainsPerFeature(opBuilder.build());
    }

    public List<Output<Integer>> nodeIdsList() {
        return this.nodeIdsList;
    }

    public List<Output<Float>> gainsList() {
        return this.gainsList;
    }

    public List<Output<Integer>> thresholdsList() {
        return this.thresholdsList;
    }

    public List<Output<Float>> leftNodeContribsList() {
        return this.leftNodeContribsList;
    }

    public List<Output<Float>> rightNodeContribsList() {
        return this.rightNodeContribsList;
    }

    private BoostedTreesCalculateBestGainsPerFeature(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int nodeIdsListLength = operation.outputListLength("node_ids_list");
        this.nodeIdsList = Arrays.asList(operation.outputList(outputIdx, nodeIdsListLength));
        int gainsListLength = operation.outputListLength("gains_list");
        this.gainsList = Arrays.asList(operation.outputList(outputIdx += nodeIdsListLength, gainsListLength));
        int thresholdsListLength = operation.outputListLength("thresholds_list");
        this.thresholdsList = Arrays.asList(operation.outputList(outputIdx += gainsListLength, thresholdsListLength));
        int leftNodeContribsListLength = operation.outputListLength("left_node_contribs_list");
        this.leftNodeContribsList = Arrays.asList(operation.outputList(outputIdx += thresholdsListLength, leftNodeContribsListLength));
        int rightNodeContribsListLength = operation.outputListLength("right_node_contribs_list");
        this.rightNodeContribsList = Arrays.asList(operation.outputList(outputIdx += leftNodeContribsListLength, rightNodeContribsListLength));
        outputIdx += rightNodeContribsListLength;
    }
}

