/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TensorArrayGather<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> value;

    public static <T> TensorArrayGather<T> create(Scope scope, Operand<?> handle, Operand<Integer> indices, Operand<Float> flowIn, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("TensorArrayGatherV3", scope.makeOpName("TensorArrayGather"));
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(flowIn.asOutput());
        opBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementShape == null) continue;
                opBuilder.setAttr("element_shape", opts.elementShape);
            }
        }
        return new TensorArrayGather<T>(opBuilder.build());
    }

    public static Options elementShape(Shape elementShape) {
        return new Options().elementShape(elementShape);
    }

    public Output<T> value() {
        return this.value;
    }

    @Override
    public Output<T> asOutput() {
        return this.value;
    }

    private TensorArrayGather(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.value = operation.output(outputIdx++);
    }

    public static class Options {
        private Shape elementShape;

        public Options elementShape(Shape elementShape) {
            this.elementShape = elementShape;
            return this;
        }

        private Options() {
        }
    }
}

