/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseToSparseSetOperation<T>
extends PrimitiveOp {
    private Output<Long> resultIndices;
    private Output<T> resultValues;
    private Output<Long> resultShape;

    public static <T> SparseToSparseSetOperation<T> create(Scope scope, Operand<Long> set1Indices, Operand<T> set1Values, Operand<Long> set1Shape, Operand<Long> set2Indices, Operand<T> set2Values, Operand<Long> set2Shape, String setOperation, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("SparseToSparseSetOperation", scope.makeOpName("SparseToSparseSetOperation"));
        opBuilder.addInput(set1Indices.asOutput());
        opBuilder.addInput(set1Values.asOutput());
        opBuilder.addInput(set1Shape.asOutput());
        opBuilder.addInput(set2Indices.asOutput());
        opBuilder.addInput(set2Values.asOutput());
        opBuilder.addInput(set2Shape.asOutput());
        opBuilder.setAttr("set_operation", setOperation);
        if (options != null) {
            for (Options opts : options) {
                if (opts.validateIndices == null) continue;
                opBuilder.setAttr("validate_indices", opts.validateIndices);
            }
        }
        return new SparseToSparseSetOperation<T>(opBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public Output<Long> resultIndices() {
        return this.resultIndices;
    }

    public Output<T> resultValues() {
        return this.resultValues;
    }

    public Output<Long> resultShape() {
        return this.resultShape;
    }

    private SparseToSparseSetOperation(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.resultIndices = operation.output(outputIdx++);
        this.resultValues = operation.output(outputIdx++);
        this.resultShape = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean validateIndices;

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }

        private Options() {
        }
    }
}

