/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseConditionalAccumulator
extends PrimitiveOp
implements Operand<String> {
    private Output<String> handle;

    public static <T> SparseConditionalAccumulator create(Scope scope, Class<T> dtype, Shape shape, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("SparseConditionalAccumulator", scope.makeOpName("SparseConditionalAccumulator"));
        opBuilder.setAttr("dtype", DataType.fromClass(dtype));
        opBuilder.setAttr("shape", shape);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.reductionType == null) continue;
                opBuilder.setAttr("reduction_type", opts.reductionType);
            }
        }
        return new SparseConditionalAccumulator(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options reductionType(String reductionType) {
        return new Options().reductionType(reductionType);
    }

    public Output<String> handle() {
        return this.handle;
    }

    @Override
    public Output<String> asOutput() {
        return this.handle;
    }

    private SparseConditionalAccumulator(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;
        private String reductionType;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options reductionType(String reductionType) {
            this.reductionType = reductionType;
            return this;
        }

        private Options() {
        }
    }
}

