/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class EditDistance
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> output;

    public static <T> EditDistance create(Scope scope, Operand<Long> hypothesisIndices, Operand<T> hypothesisValues, Operand<Long> hypothesisShape, Operand<Long> truthIndices, Operand<T> truthValues, Operand<Long> truthShape, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("EditDistance", scope.makeOpName("EditDistance"));
        opBuilder.addInput(hypothesisIndices.asOutput());
        opBuilder.addInput(hypothesisValues.asOutput());
        opBuilder.addInput(hypothesisShape.asOutput());
        opBuilder.addInput(truthIndices.asOutput());
        opBuilder.addInput(truthValues.asOutput());
        opBuilder.addInput(truthShape.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.normalize == null) continue;
                opBuilder.setAttr("normalize", opts.normalize);
            }
        }
        return new EditDistance(opBuilder.build());
    }

    public static Options normalize(Boolean normalize) {
        return new Options().normalize(normalize);
    }

    public Output<Float> output() {
        return this.output;
    }

    @Override
    public Output<Float> asOutput() {
        return this.output;
    }

    private EditDistance(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean normalize;

        public Options normalize(Boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        private Options() {
        }
    }
}

