/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DenseToDenseSetOperation<T>
extends PrimitiveOp {
    private Output<Long> resultIndices;
    private Output<T> resultValues;
    private Output<Long> resultShape;

    public static <T> DenseToDenseSetOperation<T> create(Scope scope, Operand<T> set1, Operand<T> set2, String setOperation, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("DenseToDenseSetOperation", scope.makeOpName("DenseToDenseSetOperation"));
        opBuilder.addInput(set1.asOutput());
        opBuilder.addInput(set2.asOutput());
        opBuilder.setAttr("set_operation", setOperation);
        if (options != null) {
            for (Options opts : options) {
                if (opts.validateIndices == null) continue;
                opBuilder.setAttr("validate_indices", opts.validateIndices);
            }
        }
        return new DenseToDenseSetOperation<T>(opBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public Output<Long> resultIndices() {
        return this.resultIndices;
    }

    public Output<T> resultValues() {
        return this.resultValues;
    }

    public Output<Long> resultShape() {
        return this.resultShape;
    }

    private DenseToDenseSetOperation(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.resultIndices = operation.output(outputIdx++);
        this.resultValues = operation.output(outputIdx++);
        this.resultShape = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean validateIndices;

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }

        private Options() {
        }
    }
}

