/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FakeQuantWithMinMaxVarsGradient
extends PrimitiveOp {
    private Output<Float> backpropsWrtInput;
    private Output<Float> backpropWrtMin;
    private Output<Float> backpropWrtMax;

    public static FakeQuantWithMinMaxVarsGradient create(Scope scope, Operand<Float> gradients, Operand<Float> inputs, Operand<Float> min, Operand<Float> max, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("FakeQuantWithMinMaxVarsGradient", scope.makeOpName("FakeQuantWithMinMaxVarsGradient"));
        opBuilder.addInput(gradients.asOutput());
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(min.asOutput());
        opBuilder.addInput(max.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.narrowRange == null) continue;
                opBuilder.setAttr("narrow_range", opts.narrowRange);
            }
        }
        return new FakeQuantWithMinMaxVarsGradient(opBuilder.build());
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public Output<Float> backpropsWrtInput() {
        return this.backpropsWrtInput;
    }

    public Output<Float> backpropWrtMin() {
        return this.backpropWrtMin;
    }

    public Output<Float> backpropWrtMax() {
        return this.backpropWrtMax;
    }

    private FakeQuantWithMinMaxVarsGradient(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.backpropsWrtInput = operation.output(outputIdx++);
        this.backpropWrtMin = operation.output(outputIdx++);
        this.backpropWrtMax = operation.output(outputIdx++);
    }

    public static class Options {
        private Long numBits;
        private Boolean narrowRange;

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        private Options() {
        }
    }
}

