/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class StringSplit
extends PrimitiveOp {
    private Output<Long> indices;
    private Output<String> values;
    private Output<Long> shape;

    public static StringSplit create(Scope scope, Operand<String> input, Operand<String> delimiter, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("StringSplit", scope.makeOpName("StringSplit"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(delimiter.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.skipEmpty == null) continue;
                opBuilder.setAttr("skip_empty", opts.skipEmpty);
            }
        }
        return new StringSplit(opBuilder.build());
    }

    public static Options skipEmpty(Boolean skipEmpty) {
        return new Options().skipEmpty(skipEmpty);
    }

    public Output<Long> indices() {
        return this.indices;
    }

    public Output<String> values() {
        return this.values;
    }

    public Output<Long> shape() {
        return this.shape;
    }

    private StringSplit(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.indices = operation.output(outputIdx++);
        this.values = operation.output(outputIdx++);
        this.shape = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean skipEmpty;

        public Options skipEmpty(Boolean skipEmpty) {
            this.skipEmpty = skipEmpty;
            return this;
        }

        private Options() {
        }
    }
}

