/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ResizeBilinear
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> resizedImages;

    public static <T extends Number> ResizeBilinear create(Scope scope, Operand<T> images, Operand<Integer> size, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("ResizeBilinear", scope.makeOpName("ResizeBilinear"));
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(size.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.alignCorners == null) continue;
                opBuilder.setAttr("align_corners", opts.alignCorners);
            }
        }
        return new ResizeBilinear(opBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public Output<Float> resizedImages() {
        return this.resizedImages;
    }

    @Override
    public Output<Float> asOutput() {
        return this.resizedImages;
    }

    private ResizeBilinear(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.resizedImages = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean alignCorners;

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }

        private Options() {
        }
    }
}

