/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CTCLoss
extends PrimitiveOp {
    private Output<Float> loss;
    private Output<Float> gradient;

    public static CTCLoss create(Scope scope, Operand<Float> inputs, Operand<Long> labelsIndices, Operand<Integer> labelsValues, Operand<Integer> sequenceLength, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("CTCLoss", scope.makeOpName("CTCLoss"));
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(labelsIndices.asOutput());
        opBuilder.addInput(labelsValues.asOutput());
        opBuilder.addInput(sequenceLength.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.preprocessCollapseRepeated != null) {
                    opBuilder.setAttr("preprocess_collapse_repeated", opts.preprocessCollapseRepeated);
                }
                if (opts.ctcMergeRepeated != null) {
                    opBuilder.setAttr("ctc_merge_repeated", opts.ctcMergeRepeated);
                }
                if (opts.ignoreLongerOutputsThanInputs == null) continue;
                opBuilder.setAttr("ignore_longer_outputs_than_inputs", opts.ignoreLongerOutputsThanInputs);
            }
        }
        return new CTCLoss(opBuilder.build());
    }

    public static Options preprocessCollapseRepeated(Boolean preprocessCollapseRepeated) {
        return new Options().preprocessCollapseRepeated(preprocessCollapseRepeated);
    }

    public static Options ctcMergeRepeated(Boolean ctcMergeRepeated) {
        return new Options().ctcMergeRepeated(ctcMergeRepeated);
    }

    public static Options ignoreLongerOutputsThanInputs(Boolean ignoreLongerOutputsThanInputs) {
        return new Options().ignoreLongerOutputsThanInputs(ignoreLongerOutputsThanInputs);
    }

    public Output<Float> loss() {
        return this.loss;
    }

    public Output<Float> gradient() {
        return this.gradient;
    }

    private CTCLoss(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.loss = operation.output(outputIdx++);
        this.gradient = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean preprocessCollapseRepeated;
        private Boolean ctcMergeRepeated;
        private Boolean ignoreLongerOutputsThanInputs;

        public Options preprocessCollapseRepeated(Boolean preprocessCollapseRepeated) {
            this.preprocessCollapseRepeated = preprocessCollapseRepeated;
            return this;
        }

        public Options ctcMergeRepeated(Boolean ctcMergeRepeated) {
            this.ctcMergeRepeated = ctcMergeRepeated;
            return this;
        }

        public Options ignoreLongerOutputsThanInputs(Boolean ignoreLongerOutputsThanInputs) {
            this.ignoreLongerOutputsThanInputs = ignoreLongerOutputsThanInputs;
            return this;
        }

        private Options() {
        }
    }
}

