/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BatchMatrixTriangularSolve<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> BatchMatrixTriangularSolve<T> create(Scope scope, Operand<T> matrix, Operand<T> rhs, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("BatchMatrixTriangularSolve", scope.makeOpName("BatchMatrixTriangularSolve"));
        opBuilder.addInput(matrix.asOutput());
        opBuilder.addInput(rhs.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.lower != null) {
                    opBuilder.setAttr("lower", opts.lower);
                }
                if (opts.adjoint == null) continue;
                opBuilder.setAttr("adjoint", opts.adjoint);
            }
        }
        return new BatchMatrixTriangularSolve<T>(opBuilder.build());
    }

    public static Options lower(Boolean lower) {
        return new Options().lower(lower);
    }

    public static Options adjoint(Boolean adjoint) {
        return new Options().adjoint(adjoint);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private BatchMatrixTriangularSolve(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean lower;
        private Boolean adjoint;

        public Options lower(Boolean lower) {
            this.lower = lower;
            return this;
        }

        public Options adjoint(Boolean adjoint) {
            this.adjoint = adjoint;
            return this;
        }

        private Options() {
        }
    }
}

