/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.op.Op;
import org.tensorflow.op.Operands;
import org.tensorflow.op.Scope;

public class Gradients
implements Op,
Iterable<Operand<?>> {
    private List<Output<?>> dy;

    public static Gradients create(Scope scope, Iterable<Operand<?>> y, Iterable<Operand<?>> x, Options ... options) {
        Output<?>[] dx = null;
        if (options != null) {
            for (Options opts : options) {
                if (opts.dx == null) continue;
                dx = Operands.asOutputs(opts.dx);
            }
        }
        Output<?>[] gradOutputs = scope.graph().addGradients(Operands.asOutputs(y), Operands.asOutputs(x), dx);
        return new Gradients(Arrays.asList(gradOutputs));
    }

    public static Gradients create(Scope scope, Operand<?> y, Iterable<Operand<?>> x, Options ... options) {
        return Gradients.create(scope, Arrays.asList(y), x, options);
    }

    public Options dx(Iterable<Operand<?>> dx) {
        return new Options().dx(dx);
    }

    @Override
    public Iterator<Operand<?>> iterator() {
        return this.dy.iterator();
    }

    public List<Output<?>> dy() {
        return this.dy;
    }

    public <T> Output<T> dy(int index) {
        return this.dy.get(index);
    }

    private Gradients(List<Output<?>> dy) {
        this.dy = dy;
    }

    public static class Options {
        private Iterable<Operand<?>> dx;

        public Options dx(Iterable<Operand<?>> dx) {
            this.dx = dx;
            return this;
        }

        private Options() {
        }
    }
}

