/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Split elements of `input` based on `delimiter` into a `SparseTensor`.
 * <p>
 * Let N be the size of source (typically N will be the batch size). Split each
 * element of `input` based on `delimiter` and return a `SparseTensor`
 * containing the splitted tokens. Empty tokens are ignored.
 * <p>
 * `delimiter` can be empty, or a string of split characters. If `delimiter` is an
 *  empty string, each element of `input` is split into individual single-byte
 *  character strings, including splitting of UTF-8 multibyte sequences. Otherwise
 *  every character of `delimiter` is a potential split point.
 * <p>
 * For example:
 *   N = 2, input[0] is 'hello world' and input[1] is 'a b c', then the output
 *   will be
 * <p>
 *   indices = [0, 0;
 *              0, 1;
 *              1, 0;
 *              1, 1;
 *              1, 2]
 *   shape = [2, 3]
 *   values = ['hello', 'world', 'a', 'b', 'c']
 */
@Operator
public final class StringSplit extends PrimitiveOp {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.StringSplit}
   */
  public static class Options {
    
    /**
     * @param skipEmpty A `bool`. If `True`, skip the empty strings from the result.
     */
    public Options skipEmpty(Boolean skipEmpty) {
      this.skipEmpty = skipEmpty;
      return this;
    }
    
    private Boolean skipEmpty;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new StringSplit operation to the graph.
   * 
   * @param scope current graph scope
   * @param input 1-D. Strings to split.
   * @param delimiter 0-D. Delimiter characters (bytes), or empty string.
   * @param options carries optional attributes values
   * @return a new instance of StringSplit
   */
  public static StringSplit create(Scope scope, Operand<String> input, Operand<String> delimiter, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("StringSplit", scope.makeOpName("StringSplit"));
    opBuilder.addInput(input.asOutput());
    opBuilder.addInput(delimiter.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.skipEmpty != null) {
          opBuilder.setAttr("skip_empty", opts.skipEmpty);
        }
      }
    }
    return new StringSplit(opBuilder.build());
  }
  
  /**
   * @param skipEmpty A `bool`. If `True`, skip the empty strings from the result.
   */
  public static Options skipEmpty(Boolean skipEmpty) {
    return new Options().skipEmpty(skipEmpty);
  }
  
  /**
   * A dense matrix of int64 representing the indices of the sparse tensor.
   */
  public Output<Long> indices() {
    return indices;
  }
  
  /**
   * A vector of strings corresponding to the splited values.
   */
  public Output<String> values() {
    return values;
  }
  
  /**
   * a length-2 vector of int64 representing the shape of the sparse
   * tensor, where the first value is N and the second value is the maximum number
   * of tokens in a single input entry.
   */
  public Output<Long> shape() {
    return shape;
  }
  
  private Output<Long> indices;
  private Output<String> values;
  private Output<Long> shape;
  
  private StringSplit(Operation operation) {
    super(operation);
    int outputIdx = 0;
    indices = operation.output(outputIdx++);
    values = operation.output(outputIdx++);
    shape = operation.output(outputIdx++);
  }
}
