/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Component-wise divides a SparseTensor by a dense Tensor.
 * <p>
 * <i>Limitation</i>: this Op only broadcasts the dense side to the sparse side, but not
 * the other direction.
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class SparseDenseCwiseDiv<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Factory method to create a class to wrap a new SparseDenseCwiseDiv operation to the graph.
   * 
   * @param scope current graph scope
   * @param spIndices 2-D.  `N x R` matrix with the indices of non-empty values in a
   * SparseTensor, possibly not in canonical ordering.
   * @param spValues 1-D.  `N` non-empty values corresponding to `sp_indices`.
   * @param spShape 1-D.  Shape of the input SparseTensor.
   * @param dense `R`-D.  The dense Tensor operand.
   * @return a new instance of SparseDenseCwiseDiv
   */
  public static <T> SparseDenseCwiseDiv<T> create(Scope scope, Operand<Long> spIndices, Operand<T> spValues, Operand<Long> spShape, Operand<T> dense) {
    OperationBuilder opBuilder = scope.graph().opBuilder("SparseDenseCwiseDiv", scope.makeOpName("SparseDenseCwiseDiv"));
    opBuilder.addInput(spIndices.asOutput());
    opBuilder.addInput(spValues.asOutput());
    opBuilder.addInput(spShape.asOutput());
    opBuilder.addInput(dense.asOutput());
    return new SparseDenseCwiseDiv<T>(opBuilder.build());
  }
  
  /**
   * 1-D.  The `N` values that are operated on.
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private SparseDenseCwiseDiv(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
