/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Returns true if queue is closed.
 * <p>
 * This operation returns true if the queue is closed and false if the queue
 * is open.
 */
@Operator
public final class QueueIsClosedV2 extends PrimitiveOp implements Operand<Boolean> {
  
  /**
   * Factory method to create a class to wrap a new QueueIsClosedV2 operation to the graph.
   * 
   * @param scope current graph scope
   * @param handle The handle to a queue.
   * @return a new instance of QueueIsClosedV2
   */
  public static QueueIsClosedV2 create(Scope scope, Operand<?> handle) {
    OperationBuilder opBuilder = scope.graph().opBuilder("QueueIsClosedV2", scope.makeOpName("QueueIsClosedV2"));
    opBuilder.addInput(handle.asOutput());
    return new QueueIsClosedV2(opBuilder.build());
  }
  
  /**
   */
  public Output<Boolean> isClosed() {
    return isClosed;
  }
  
  @Override
  public Output<Boolean> asOutput() {
    return isClosed;
  }
  
  private Output<Boolean> isClosed;
  
  private QueueIsClosedV2(Operation operation) {
    super(operation);
    int outputIdx = 0;
    isClosed = operation.output(outputIdx++);
  }
}
