/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Gather slices from `params` according to `indices`.
 * <p>
 * `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
 * Produces an output tensor with shape `indices.shape + params.shape[1:]` where:
 * <pre>{@code
 *     # Scalar indices
 *     output[:, ..., :] = params[indices, :, ... :]
 * 
 *     # Vector indices
 *     output[i, :, ..., :] = params[indices[i], :, ... :]
 * 
 *     # Higher rank indices
 *     output[i, ..., j, :, ... :] = params[indices[i, ..., j], :, ..., :]
 * }</pre>
 * If `indices` is a permutation and `len(indices) == params.shape[0]` then
 * this operation will permute `params` accordingly.
 * <p>
 * `validate_indices`: DEPRECATED. If this operation is assigned to CPU, values in
 * `indices` are always validated to be within range. If assigned to GPU,
 * out-of-bound indices result in safe but unspecified behavior, which may include
 * raising an error.
 * <p>
 * <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
 * <img style="width:100%" src="https://www.tensorflow.org/images/Gather.png" alt>
 * </div>
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class Gather<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.Gather}
   */
  public static class Options {
    
    /**
     * @param validateIndices 
     */
    public Options validateIndices(Boolean validateIndices) {
      this.validateIndices = validateIndices;
      return this;
    }
    
    private Boolean validateIndices;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new Gather operation to the graph.
   * 
   * @param scope current graph scope
   * @param params 
   * @param indices 
   * @param options carries optional attributes values
   * @return a new instance of Gather
   */
  public static <T, U extends Number> Gather<T> create(Scope scope, Operand<T> params, Operand<U> indices, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("Gather", scope.makeOpName("Gather"));
    opBuilder.addInput(params.asOutput());
    opBuilder.addInput(indices.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.validateIndices != null) {
          opBuilder.setAttr("validate_indices", opts.validateIndices);
        }
      }
    }
    return new Gather<T>(opBuilder.build());
  }
  
  /**
   * @param validateIndices 
   */
  public static Options validateIndices(Boolean validateIndices) {
    return new Options().validateIndices(validateIndices);
  }
  
  /**
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private Gather(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
