/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * PNG-encode an image.
 * <p>
 * `image` is a 3-D uint8 or uint16 Tensor of shape `[height, width, channels]`
 * where `channels` is:
 * <ul>
 * <li>
 * 1: for grayscale.
 * </li>
 * <li>
 * 2: for grayscale + alpha.
 * </li>
 * <li>
 * 3: for RGB.
 * </li>
 * <li>
 * 4: for RGBA.
 * </li>
 * </ul>
 * The ZLIB compression level, `compression`, can be -1 for the PNG-encoder
 * default or a value from 0 to 9.  9 is the highest compression level, generating
 * the smallest output, but is slower.
 */
@Operator
public final class EncodePng extends PrimitiveOp implements Operand<String> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.EncodePng}
   */
  public static class Options {
    
    /**
     * @param compression Compression level.
     */
    public Options compression(Long compression) {
      this.compression = compression;
      return this;
    }
    
    private Long compression;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new EncodePng operation to the graph.
   * 
   * @param scope current graph scope
   * @param image 3-D with shape `[height, width, channels]`.
   * @param options carries optional attributes values
   * @return a new instance of EncodePng
   */
  public static <T extends Number> EncodePng create(Scope scope, Operand<T> image, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("EncodePng", scope.makeOpName("EncodePng"));
    opBuilder.addInput(image.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.compression != null) {
          opBuilder.setAttr("compression", opts.compression);
        }
      }
    }
    return new EncodePng(opBuilder.build());
  }
  
  /**
   * @param compression Compression level.
   */
  public static Options compression(Long compression) {
    return new Options().compression(compression);
  }
  
  /**
   * 0-D. PNG-encoded image.
   */
  public Output<String> contents() {
    return contents;
  }
  
  @Override
  public Output<String> asOutput() {
    return contents;
  }
  
  private Output<String> contents;
  
  private EncodePng(Operation operation) {
    super(operation);
    int outputIdx = 0;
    contents = operation.output(outputIdx++);
  }
}
