/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * @param <T> data type for {@code e()} output
 */
@Operator
public final class BatchSelfAdjointEigV2<T extends Number> extends PrimitiveOp {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.BatchSelfAdjointEigV2}
   */
  public static class Options {
    
    /**
     * @param computeV 
     */
    public Options computeV(Boolean computeV) {
      this.computeV = computeV;
      return this;
    }
    
    private Boolean computeV;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new BatchSelfAdjointEigV2 operation to the graph.
   * 
   * @param scope current graph scope
   * @param input 
   * @param options carries optional attributes values
   * @return a new instance of BatchSelfAdjointEigV2
   */
  public static <T extends Number> BatchSelfAdjointEigV2<T> create(Scope scope, Operand<T> input, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("BatchSelfAdjointEigV2", scope.makeOpName("BatchSelfAdjointEigV2"));
    opBuilder.addInput(input.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.computeV != null) {
          opBuilder.setAttr("compute_v", opts.computeV);
        }
      }
    }
    return new BatchSelfAdjointEigV2<T>(opBuilder.build());
  }
  
  /**
   * @param computeV 
   */
  public static Options computeV(Boolean computeV) {
    return new Options().computeV(computeV);
  }
  
  /**
   */
  public Output<T> e() {
    return e;
  }
  
  /**
   */
  public Output<T> v() {
    return v;
  }
  
  private Output<T> e;
  private Output<T> v;
  
  private BatchSelfAdjointEigV2(Operation operation) {
    super(operation);
    int outputIdx = 0;
    e = operation.output(outputIdx++);
    v = operation.output(outputIdx++);
  }
}
