/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TensorSummary
extends PrimitiveOp
implements Operand<String> {
    private Output<String> summary;

    public static <T> TensorSummary create(Scope scope, Operand<T> tensor, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("TensorSummary", scope.makeOpName("TensorSummary"));
        opBuilder.addInput(tensor.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.description != null) {
                    opBuilder.setAttr("description", opts.description);
                }
                if (opts.labels != null) {
                    String[] labelsArray = new String[opts.labels.size()];
                    for (int i = 0; i < labelsArray.length; ++i) {
                        labelsArray[i] = (String)opts.labels.get(i);
                    }
                    opBuilder.setAttr("labels", labelsArray);
                }
                if (opts.displayName == null) continue;
                opBuilder.setAttr("display_name", opts.displayName);
            }
        }
        return new TensorSummary(opBuilder.build());
    }

    public static Options description(String description) {
        return new Options().description(description);
    }

    public static Options labels(List<String> labels) {
        return new Options().labels(labels);
    }

    public static Options displayName(String displayName) {
        return new Options().displayName(displayName);
    }

    public Output<String> summary() {
        return this.summary;
    }

    @Override
    public Output<String> asOutput() {
        return this.summary;
    }

    private TensorSummary(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.summary = operation.output(outputIdx++);
    }

    public static class Options {
        private String description;
        private List<String> labels;
        private String displayName;

        public Options description(String description) {
            this.description = description;
            return this;
        }

        public Options labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Options displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        private Options() {
        }
    }
}

