/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ResourceGather<U>
extends PrimitiveOp
implements Operand<U> {
    private Output<U> output;

    public static <U, T extends Number> ResourceGather<U> create(Scope scope, Operand<?> resource, Operand<T> indices, Class<U> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("ResourceGather", scope.makeOpName("ResourceGather"));
        opBuilder.addInput(resource.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.validateIndices == null) continue;
                opBuilder.setAttr("validate_indices", opts.validateIndices);
            }
        }
        return new ResourceGather<U>(opBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    private ResourceGather(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean validateIndices;

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }

        private Options() {
        }
    }
}

