/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QueueDequeueUpTo
extends PrimitiveOp
implements Iterable<Operand<Object>> {
    private List<Output<?>> components;

    public static QueueDequeueUpTo create(Scope scope, Operand<?> handle, Operand<Integer> n, List<Class<?>> componentTypes, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("QueueDequeueUpToV2", scope.makeOpName("QueueDequeueUpTo"));
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(n.asOutput());
        DataType[] componentTypesArray = new DataType[componentTypes.size()];
        for (int i = 0; i < componentTypesArray.length; ++i) {
            componentTypesArray[i] = DataType.fromClass(componentTypes.get(i));
        }
        opBuilder.setAttr("component_types", componentTypesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.timeoutMs == null) continue;
                opBuilder.setAttr("timeout_ms", opts.timeoutMs);
            }
        }
        return new QueueDequeueUpTo(opBuilder.build());
    }

    public static Options timeoutMs(Long timeoutMs) {
        return new Options().timeoutMs(timeoutMs);
    }

    public List<Output<?>> components() {
        return this.components;
    }

    @Override
    public Iterator<Operand<Object>> iterator() {
        return this.components.iterator();
    }

    private QueueDequeueUpTo(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int componentsLength = operation.outputListLength("components");
        this.components = Arrays.asList(operation.outputList(outputIdx, componentsLength));
        outputIdx += componentsLength;
    }

    public static class Options {
        private Long timeoutMs;

        public Options timeoutMs(Long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        private Options() {
        }
    }
}

