/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedRelu<U>
extends PrimitiveOp {
    private Output<U> activations;
    private Output<Float> minActivations;
    private Output<Float> maxActivations;

    public static <U, T> QuantizedRelu<U> create(Scope scope, Operand<T> features, Operand<Float> minFeatures, Operand<Float> maxFeatures, Class<U> outType) {
        OperationBuilder opBuilder = scope.graph().opBuilder("QuantizedRelu", scope.makeOpName("QuantizedRelu"));
        opBuilder.addInput(features.asOutput());
        opBuilder.addInput(minFeatures.asOutput());
        opBuilder.addInput(maxFeatures.asOutput());
        opBuilder.setAttr("out_type", DataType.fromClass(outType));
        return new QuantizedRelu<U>(opBuilder.build());
    }

    public Output<U> activations() {
        return this.activations;
    }

    public Output<Float> minActivations() {
        return this.minActivations;
    }

    public Output<Float> maxActivations() {
        return this.maxActivations;
    }

    private QuantizedRelu(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.activations = operation.output(outputIdx++);
        this.minActivations = operation.output(outputIdx++);
        this.maxActivations = operation.output(outputIdx++);
    }
}

