/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CudnnRNNBackpropV2<T extends Number>
extends PrimitiveOp {
    private Output<T> inputBackprop;
    private Output<T> inputHBackprop;
    private Output<T> inputCBackprop;
    private Output<T> paramsBackprop;

    public static <T extends Number> CudnnRNNBackpropV2<T> create(Scope scope, Operand<T> input, Operand<T> inputH, Operand<T> inputC, Operand<T> params, Operand<T> output, Operand<T> outputH, Operand<T> outputC, Operand<T> outputBackprop, Operand<T> outputHBackprop, Operand<T> outputCBackprop, Operand<T> reserveSpace, Operand<?> hostReserved, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("CudnnRNNBackpropV2", scope.makeOpName("CudnnRNNBackpropV2"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(inputH.asOutput());
        opBuilder.addInput(inputC.asOutput());
        opBuilder.addInput(params.asOutput());
        opBuilder.addInput(output.asOutput());
        opBuilder.addInput(outputH.asOutput());
        opBuilder.addInput(outputC.asOutput());
        opBuilder.addInput(outputBackprop.asOutput());
        opBuilder.addInput(outputHBackprop.asOutput());
        opBuilder.addInput(outputCBackprop.asOutput());
        opBuilder.addInput(reserveSpace.asOutput());
        opBuilder.addInput(hostReserved.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.rnnMode != null) {
                    opBuilder.setAttr("rnn_mode", opts.rnnMode);
                }
                if (opts.inputMode != null) {
                    opBuilder.setAttr("input_mode", opts.inputMode);
                }
                if (opts.direction != null) {
                    opBuilder.setAttr("direction", opts.direction);
                }
                if (opts.dropout != null) {
                    opBuilder.setAttr("dropout", opts.dropout.floatValue());
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new CudnnRNNBackpropV2<T>(opBuilder.build());
    }

    public static Options rnnMode(String rnnMode) {
        return new Options().rnnMode(rnnMode);
    }

    public static Options inputMode(String inputMode) {
        return new Options().inputMode(inputMode);
    }

    public static Options direction(String direction) {
        return new Options().direction(direction);
    }

    public static Options dropout(Float dropout) {
        return new Options().dropout(dropout);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<T> inputBackprop() {
        return this.inputBackprop;
    }

    public Output<T> inputHBackprop() {
        return this.inputHBackprop;
    }

    public Output<T> inputCBackprop() {
        return this.inputCBackprop;
    }

    public Output<T> paramsBackprop() {
        return this.paramsBackprop;
    }

    private CudnnRNNBackpropV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.inputBackprop = operation.output(outputIdx++);
        this.inputHBackprop = operation.output(outputIdx++);
        this.inputCBackprop = operation.output(outputIdx++);
        this.paramsBackprop = operation.output(outputIdx++);
    }

    public static class Options {
        private String rnnMode;
        private String inputMode;
        private String direction;
        private Float dropout;
        private Long seed;
        private Long seed2;

        public Options rnnMode(String rnnMode) {
            this.rnnMode = rnnMode;
            return this;
        }

        public Options inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        public Options direction(String direction) {
            this.direction = direction;
            return this;
        }

        public Options dropout(Float dropout) {
            this.dropout = dropout;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

