/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class StringSplitV2
extends PrimitiveOp {
    private Output<Long> indices;
    private Output<String> values;
    private Output<Long> shape;

    public static StringSplitV2 create(Scope scope, Operand<String> input, Operand<String> sep, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("StringSplitV2", scope.makeOpName("StringSplitV2"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(sep.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxsplit == null) continue;
                opBuilder.setAttr("maxsplit", opts.maxsplit);
            }
        }
        return new StringSplitV2(opBuilder.build());
    }

    public static Options maxsplit(Long maxsplit) {
        return new Options().maxsplit(maxsplit);
    }

    public Output<Long> indices() {
        return this.indices;
    }

    public Output<String> values() {
        return this.values;
    }

    public Output<Long> shape() {
        return this.shape;
    }

    private StringSplitV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.indices = operation.output(outputIdx++);
        this.values = operation.output(outputIdx++);
        this.shape = operation.output(outputIdx++);
    }

    public static class Options {
        private Long maxsplit;

        public Options maxsplit(Long maxsplit) {
            this.maxsplit = maxsplit;
            return this;
        }

        private Options() {
        }
    }
}

