/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RestoreSlice<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> tensor;

    public static <T> RestoreSlice<T> create(Scope scope, Operand<String> filePattern, Operand<String> tensorName, Operand<String> shapeAndSlice, Class<T> dt, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("RestoreSlice", scope.makeOpName("RestoreSlice"));
        opBuilder.addInput(filePattern.asOutput());
        opBuilder.addInput(tensorName.asOutput());
        opBuilder.addInput(shapeAndSlice.asOutput());
        opBuilder.setAttr("dt", DataType.fromClass(dt));
        if (options != null) {
            for (Options opts : options) {
                if (opts.preferredShard == null) continue;
                opBuilder.setAttr("preferred_shard", opts.preferredShard);
            }
        }
        return new RestoreSlice<T>(opBuilder.build());
    }

    public static Options preferredShard(Long preferredShard) {
        return new Options().preferredShard(preferredShard);
    }

    public Output<T> tensor() {
        return this.tensor;
    }

    @Override
    public Output<T> asOutput() {
        return this.tensor;
    }

    private RestoreSlice(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.tensor = operation.output(outputIdx++);
    }

    public static class Options {
        private Long preferredShard;

        public Options preferredShard(Long preferredShard) {
            this.preferredShard = preferredShard;
            return this;
        }

        private Options() {
        }
    }
}

